<h2>Why is this an issue?</h2>
<p>It is very easy to write incomplete assertions when using some test frameworks. This rule enforces complete assertions in the following cases:</p>
<ul>
  <li> Fest: <code>assertThat</code> is not followed by an assertion invocation </li>
  <li> AssertJ: <code>assertThat</code> is not followed by an assertion invocation </li>
  <li> Mockito: <code>verify</code> is not followed by a method invocation </li>
  <li> Truth: <code>assertXXX</code> is not followed by an assertion invocation </li>
</ul>
<p>In such cases, what is intended to be a test doesn’t actually verify anything</p>
<h3>Noncompliant code example</h3>

```java
// Fest
boolean result = performAction();
// let's now check that result value is true
assertThat(result); // Noncompliant; nothing is actually checked, the test passes whether "result" is true or false

// Mockito
List mockedList = Mockito.mock(List.class);
mockedList.add("one");
mockedList.clear();
// let's check that "add" and "clear" methods are actually called
Mockito.verify(mockedList); // Noncompliant; nothing is checked here, oups no call is chained to verify()
```
<h3>Compliant solution</h3>

```java
// Fest
boolean result = performAction();
// let's now check that result value is true
assertThat(result).isTrue();

// Mockito
List mockedList = Mockito.mock(List.class);
mockedList.add("one");
mockedList.clear();
// let's check that "add" and "clear" methods are actually called
Mockito.verify(mockedList).add("one");
Mockito.verify(mockedList).clear();
```
<h3>Exceptions</h3>
<p>Variable assignments and return statements are skipped to allow helper methods.</p>

```java
private BooleanAssert check(String filename, String key) {
  String fileContent = readFileContent(filename);
  performReplacements(fileContent);
  return assertThat(fileContent.contains(key)); // No issue is raised here
}

@Test
public void test() {
  check("foo.txt", "key1").isTrue();
  check("bar.txt", "key2").isTrue();
}
```