<h2>Why is this an issue?</h2>
<p>According to the documentation,</p>
<blockquote>
  <p>A program may produce unpredictable results if it attempts to distinguish two references to equal values of a value-based class, whether directly
  via reference equality or indirectly via an appeal to synchronization, identity hashing, serialization…​</p>
</blockquote>
<p>For example (credit to Brian Goetz), imagine Foo is a value-based class:</p>

```java
Foo[] arr = new Foo[2];
arr[0] = new Foo(0);
arr[1] = new Foo(0);
```
<p>Serialization promises that on deserialization of arr, elements 0 and 1 will not be aliased. Similarly, in:</p>

```java
Foo[] arr = new Foo[2];
arr[0] = new Foo(0);
arr[1] = arr[0];
```
<p>Serialization promises that on deserialization of <code>arr</code>, elements 0 and 1 <strong>will</strong> be aliased.</p>
<p>While these promises are coincidentally fulfilled in current implementations of Java, that is not guaranteed in the future, particularly when true
value types are introduced in the language.</p>
<p>This rule raises an issue when a <code>Serializable</code> class defines a non-transient, non-static field field whose type is a known serializable
value-based class. Known serializable value-based classes are: all the classes in the <code>java.time</code> package except <code>Clock</code>; the
date classes for alternate calendars: <code>HijrahDate</code>, <code>JapaneseDate</code>, <code>MinguoDate</code>, <code>ThaiBuddhistDate</code>.</p>
<h3>Noncompliant code example</h3>

```java
class MyClass implements Serializable {
  private HijrahDate date;  // Noncompliant; mark this transient
  // ...
}
```
<h3>Compliant solution</h3>

```java
class MyClass implements Serializable {
  private transient HijrahDate date;
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/lang/doc-files/ValueBased.html">Value-based classes</a> </li>
</ul>