<h2>Why is this an issue?</h2>
<p>Spring framework 4.3 introduced variants of the <code>@RequestMapping</code> annotation to better represent the semantics of the annotated methods.
The use of <code>@GetMapping</code>, <code>@PostMapping</code>, <code>@PutMapping</code>, <code>@PatchMapping</code> and <code>@DeleteMapping</code>
should be preferred to the use of the raw <code>@RequestMapping(method = RequestMethod.XYZ)</code>.</p>
<h3>Noncompliant code example</h3>

```java
@RequestMapping(path = "/greeting", method = RequestMethod.GET) // Noncompliant
public Greeting greeting(@RequestParam(value = "name", defaultValue = "World") String name) {
...
}
```
<h3>Compliant solution</h3>

```java
@GetMapping(path = "/greeting") // Compliant
public Greeting greeting(@RequestParam(value = "name", defaultValue = "World") String name) {
...
}
```