<h2>Why is this an issue?</h2>
<p>When verifying that code raises a runtime exception, a good practice is to avoid having multiple method calls inside the tested code, to be
explicit about which method call is expected to raise the exception.</p>
<p>It increases the clarity of the test, and avoid incorrect testing when another method is actually raising the exception.</p>
<h3>Noncompliant code example</h3>

```java
@Test
public void testToString() {
  // Do you expect get() or toString() throwing the exception?
  org.junit.Assert.assertThrows(IndexOutOfBoundsException.class, () -> get().toString());
}

@Test
public void testToStringTryCatchIdiom() {
  try {
    // Do you expect get() or toString() throwing the exception?
    get().toString();
    Assert.fail("Expected an IndexOutOfBoundsException to be thrown");
  } catch (IndexOutOfBoundsException e) {
    // Test exception message...
  }
}
```
<h3>Compliant solution</h3>

```java
@Test
public void testToString() {
   Object obj = get();
   Assert.assertThrows(IndexOutOfBoundsException.class, () -> obj.toString());
}

@Test
public void testToStringTryCatchIdiom() {
  Object obj = get();
  try {
    obj.toString();
    Assert.fail("Expected an IndexOutOfBoundsException to be thrown");
  } catch (IndexOutOfBoundsException e) {
    // Test exception message...
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://github.com/junit-team/junit4/wiki/Exception-testing">JUnit exception testing documentation</a> </li>
</ul>