<h2>Why is this an issue?</h2>
<p>AssertJ assertions <code>allMatch</code> and <code>doesNotContains</code> on an empty list always&nbsp;returns true whatever the content of the
predicate. Despite being correct, you should make explicit if you expect an empty list or not, by adding
<code>isEmpty()</code>/<code>isNotEmpty()</code> in addition to calling the assertion, or by testing the list’s content further. It will justify the
useless predicate to improve clarity or increase the reliability of the test.</p>
<p>This rule raises an issue when any of the methods listed are used without asserting that the list is empty or not and without testing the
content.</p>
<p>Targetted methods:</p>
<ul>
  <li> <code>allMatch</code> </li>
  <li> <code>allSatisfy</code> </li>
  <li> <code>doesNotContain</code> </li>
  <li> <code>doesNotContainSequence</code> </li>
  <li> <code>doesNotContainSubsequence</code> </li>
  <li> <code>doesNotContainAnyElementsOf</code> </li>
</ul>
<h3>Noncompliant code example</h3>

```java
List<String> logs = getLogs();

assertThat(logs).allMatch(e -> e.contains(“error”)); // Noncompliant, this test pass if logs are empty!
assertThat(logs).doesNotContain("error"); // Noncompliant, do you expect any log?
```
<h3>Compliant solution</h3>

```java
List<String> logs = getLogs();

assertThat(logs).isNotEmpty().allMatch(e -> e.contains(“error”));
// Or
assertThat(logs).hasSize(5).allMatch(e -> e.contains(“error”));
// Or
assertThat(logs).isEmpty();

// Despite being redundant, this is also acceptable since it explains why you expect an empty list
assertThat(logs).doesNotContain("error").isEmpty();
// or test the content of the list further
assertThat(logs).contains("warning").doesNotContain("error");
```