<h2>Why is this an issue?</h2>
<p>Some API, like the AWS SDK, heavily rely on the builder pattern to create different data structures. Despite all the benefits, this pattern can
become really verbose, especially when dealing with nested structures. In order to reach a more concise code, "Consumer Builders", also called
"Consumer Interface" are often introduced.</p>
<p>The idea is to overload the methods taking others structures in a Builder with a Consumer of Builder instead. This enables to use a lambda instead
of nesting another Builder, resulting in more concise and readable code.</p>
<p>This rule reports an issue when the Consumer Builder methods could be used instead of the classical ones.</p>
<h3>Noncompliant code example</h3>

```java
SendEmailRequest.builder()
  .destination(Destination.builder()
    .toAddresses("to-email@domain.com")
    .bccAddresses("bcc-email@domain.com")
    .build())
.build();
```
<h3>Compliant solution</h3>

```java
SendEmailRequest.builder()
  .destination(d -> d.toAddresses("to-email@domain.com").bccAddresses("bcc-email@domain.com"))
  .build();
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://aws.amazon.com/fr/blogs/developer/consumer-builders-in-the-aws-sdk-for-java-v2/">Consumer Builders in the AWS SDK for Java
  v2</a> </li>
</ul>