<h2>Why is this an issue?</h2>
<p>The types of the arguments that built-in functions accept are specified in the JavaScript language specification. Calls to these functions should
conform to the documented types as they are designed to work with specific data types. If the arguments passed to these functions do not match the
expected types, it can lead to type errors or unexpected behavior.</p>
<p>Additionally, passing the correct types of arguments to built-in functions can improve performance by reducing the need for type conversions and
other operations.</p>

```js
const isTooSmall = Math.abs(x < 0.0042); // Noncompliant: 'Math.abs' takes a number as argument
```
<p>Ensure that the arguments passed to built-in functions match the documented types. This is an important aspect of writing high-quality,
maintainable, and performant code. You can refer to the Mozilla Developer Network (MDN) documentation for the built-in functions. The documentation
typically includes information about the expected types of arguments, the return type of the function, and any other relevant details.</p>

```js
const isTooSmall = Math.abs(x) < 0.0042;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects">Global Objects</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#type_coercion">Type coercion</a> </li>
</ul>