<h2>Why is this an issue?</h2>
<p><code>for...of</code> statements are used to iterate over the values of an iterable object. <a
href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols#the_iterable_protocol">Iterables</a> are objects
implementing the <code>@@iterator</code> method, which returns an object conforming to the <a
href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols#the_iterator_protocol">iterator protocol</a>. JavaScript
provides many <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols#built-in_iterables">built-in
iterables</a> that can and should be used with this looping statement.</p>
<p>The use of the <code>for...of</code> statement is recommended over the <code>for</code> statement when iterating through iterable objects as
simplifies the syntax and eliminates the need for a counter variable.</p>

```js
const arr = [4, 3, 2, 1];

for (let i = 0; i < arr.length; i++) {  // Noncompliant: arr is an iterable object
  console.log(arr[i]);
}
```
<p>When looping over an iterable, use the <code>for...of</code> for better readability.</p>

```js
const arr = [4, 3, 2, 1];

for (let value of arr) {
  console.log(value);
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for...of"><code>for...of</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols#the_iterator_protocol">Iterator
  protocol</a> </li>
</ul>