<h2>Why is this an issue?</h2>
<p>Table headers are essential to enhance the accessibility of a table’s data, particularly for assistive technologies like screen readers. These
headers provide the necessary context to transform data into information. Without headers, users get rapidly lost in the flow of data.</p>
<p>This rule raises an issue whenever it detects a table that does not have a full row or column with <code>&lt;th&gt;</code> elements.</p>
<h3>Exceptions</h3>
<p>No issue will be raised on <code>&lt;table&gt;</code> used for layout purpose, i.e. when it contains a <code>role</code> attribute set to
<code>"presentation"</code> or <code>"none"</code>.</p>

```js
<table role="presentation">
  <tr>
    <td>Name</td>
    <td>Age</td>
  </tr>
  <tr>
    <td>John Doe</td>
    <td>42</td>
  </tr>
</table>
```
<p>Note that <a href="https://www.w3schools.com/html/html_layout.asp">using &lt;table&gt; for layout purpose is a bad practice</a>.</p>
<p>No issue will be raised on <code>&lt;table&gt;</code> containing an <code>aria-hidden</code> attribute set to <code>"true"</code>.</p>

```js
<table aria-hidden="true">
  <tr>
    <td>Name</td>
    <td>Age</td>
  </tr>
  <tr>
    <td>John Doe</td>
    <td>42</td>
  </tr>
</table>
```
<h2>How to fix it</h2>
<p>The first <code>&lt;tr&gt;</code> of the table should contain <code>&lt;th&gt;</code> elements, with the appropriate description of what the data
in those columns represents.</p>
<h3>Going the extra mile</h3>
<p>Headers should be properly associated with the corresponding <code>&lt;td&gt;</code> cells by using either a <code>scope</code> attribute or
<code>headers</code> and <code>id</code> attributes. See <a href="https://www.w3.org/WAI/tutorials/tables/tips/">W3C WAI Web Accessibility
Tutorials</a> for more information.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
<table> <!-- Noncompliant -->
  <tr>
    <td>Name</td>
    <td>Age</td>
  </tr>
  <tr>
    <td>John Doe</td>
    <td>24</td>
  </tr>
  <tr>
    <td>Alice Doe</td>
    <td>54</td>
  </tr>
</table>
```
<h4>Compliant solution</h4>

```js
<table>
  <tr>
    <th scope="col">Name</th>
    <th scope="col">Age</th>
  </tr>
  <tr>
    <td>John Doe</td>
    <td>24</td>
  </tr>
  <tr>
    <td>Alice Doe</td>
    <td>54</td>
  </tr>
</table>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.w3.org/WAI/WCAG21/quickref/?versions=2.0#qr-content-structure-separation-programmatic">WCAG2, 1.3.1</a>&nbsp;-&nbsp;Info
  and Relationships </li>
  <li> <a href="https://www.w3.org/TR/WCAG20-TECHS/H51">WCAG2,&nbsp;H51</a> - Using table markup to present tabular information </li>
</ul>