<h2>Why is this an issue?</h2>
<p>If a <code>&lt;td&gt;</code> cell has a <code>headers</code> attribute, it should reference only IDs of headers in the same column and row.</p>
<p>Note that it is usually better to use <code>scope</code> attributes of <code>&lt;th&gt;</code> headers instead of <code>headers</code> attribute.
<code>headers</code> attribute requires you to list every corresponding <code>&lt;th&gt;</code> header’s <code>id</code>, which is error-prone and
makes the code less maintainable. See&nbsp;<a href="https://www.w3.org/WAI/tutorials/tables/tips/">W3C WAI&nbsp;Web Accessibility
Tutorials</a>&nbsp;for more information.</p>
<p>If your table is too complex, it might be better to split it into multiple small tables as it improves both readability and maintainability.</p>
<p>This rule raises an issue when the <code>headers</code> attribute of a <code>&lt;td&gt;</code> cell contains IDs which don’t belong to a header in
the same row or column.</p>
<h3>Noncompliant code example</h3>

```js
<table border="1">
<caption>
    Rental price
</caption>
<thead>
    <tr>
        <td></td>
        <th id="small" scope="col">
            Small car
        </th>
        <th id="big" scope="col">
            Big Car
        </th>
    </tr>
</thead>
<tbody>
    <tr>
        <th id="paris" class="span" colspan="3" scope="colgroup">
            Paris
        </th>
        </tr>
        <tr>
        <th headers="paris" id="day1">
            1 day
        </th>
        <td headers="paris day1 big"> <!-- Noncompliant, referencing the column "big" instead of "small" -->
            11 euros
        </td>
        <td headers="berlin day1 big"> <!-- Noncompliant, there is no header with id "berlin" -->
            50 euros
        </td>
        </tr>
    </tr>
</tbody>
</table>
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://www.w3.org/WAI/WCAG21/quickref/?versions=2.0#qr-content-structure-separation-programmatic">WCAG2, 1.3.1</a>&nbsp;-&nbsp;Info
  and Relationships </li>
  <li> <a href="https://www.w3.org/TR/WCAG20-TECHS/html.html#H43">WCAG2, H43</a> - Using id and headers attributes to associate data cells with header
  cells in data tables </li>
</ul>