<h2>Why is this an issue?</h2>
<p>References in a class to static class members (fields or methods) can be made using either <code>self::$var</code> or <code>static::$var</code>
(introduced in 5.3). The difference between the two is one of scope. Confusingly, in subclasses, the use of <code>self::</code> references the
original definition of the member, i.e. the superclass version, rather than any override at the subclass level. <code>static::</code>, on the other
hand, references the class that was called at runtime.</p>
<h3>Noncompliant code example</h3>

```php
<?php

class Toy {

    public static function status() {
        self::getStatus();  // Noncompliant; will always print "Sticks are fun!" even when called from a subclass which overrides this method;
    }

    protected static function getStatus() {
        echo "Sticks are fun!";
    }
}

class Ball extends Toy {

    protected static function getStatus() {  // Doesn't actually get called
        echo "Balls are fun!";
    }
}

$myBall = new Ball();
$myBall::status();  // Prints "Sticks are fun!"
```
<h3>Compliant solution</h3>

```php
<?php

class Toy {

    public static function status() {
        static::getStatus();  // Compliant
    }

    protected static function getStatus() {
        echo "Sticks are fun!";
    }
}

class Ball extends Toy {

    protected static function getStatus() {
        echo "Balls are fun!";
    }
}

$myBall = new Ball();
$myBall::status();  // Prints "Balls are fun!"
```
<h3>Exceptions</h3>
<p>No issue is raised when <code>self</code> is used on a constant field, a private field or a private method.</p>

```php
class A
{
    private static $somevar = "hello";
    const CONSTANT = 42;

    private static function foo()
    {
        $var = self::$somevar . self::CONSTANT;  // Should be OK
        self::foo();                               // Should be OK
    }
}
```