<p>This rule is deprecated; use javascript:S4507 instead.</p>
<h2>Why is this an issue?</h2>
<p>The debugger statement can be placed anywhere in procedures to suspend execution. Using the debugger statement is similar to setting a breakpoint
in the code. By definition such statement must absolutely be removed from the source code to prevent any unexpected behavior or added vulnerability to
attacks in production.</p>
<h3>Noncompliant code example</h3>

```ts
for (i = 1; i<5; i++) {
  // Print i to the Output window.
  Debug.write("loop index is " + i);
  // Wait for user to resume.
  debugger;
}
```
<h3>Compliant solution</h3>

```ts
for (i = 1; i<5; i++) {
  // Print i to the Output window.
  Debug.write("loop index is " + i);
}
```
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure">Top 10 2017 Category A3 - Sensitive Data
  Exposure</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/489">CWE-489 - Active Debug Code</a> </li>
</ul>