This check detects usages of the standard API objects that are `Deprecated`, `Not to Be Released`, or `Not To Be Released Stable` using [Cloudification Repository](https://sap.github.io/abap-atc-cr-cv-s4hc/) information.

You can configure which release version file is used (e.g., `objectReleaseInfo_PCE2022_1`) in the analysis profile. The default is `objectReleaseInfoLatest`.

In addition, make sure to configure which states are enabled to be checked in the analysis profile.

Different states of an object.
- `Deprecated` - The object is released, but in ADT you get a warning that the object is `Deprecated`. A successor may be available.
- `Not To Be Released` - The object is not released, but there is a successor that can be used.
- `Not To Be Released Stable` - The object is not released by SAP, but can be used in a TIER-2 wrapper because it will no longer be changed.

# Why is This a Problem?

In ABAP for Cloud Development, the use of objects types that are not allowed in the Cloud or unreleased APIs can result to bugs, performance issues and other kinds of application problems.

# How Can I Resolve This?

Replace unpermitted object types with suitable released cloud-ready objects.

## Example (Before)

```ABAP
DATA bool_tmp TYPE BOOLE_D.
```

## Example (After)

```ABAP
DATA bool_tmp TYPE ABAP_BOOLEAN.
```

# Where Can I Learn More?

## References

- [Cloudification Repository](https://github.com/SAP/abap-atc-cr-cv-s4hc)
- [Cloudification Repository Viewer](https://sap.github.io/abap-atc-cr-cv-s4hc/)
- [ABAP Cloud - How to mitigate missing released SAP APIs in SAP S/4HANA Cloud](https://community.sap.com/t5/enterprise-resource-planning-blogs-by-sap/abap-cloud-how-to-mitigate-missing-released-sap-apis-in-sap-s-4hana-cloud/ba-p/13561479)