Having multiple ABAP statements on the same line can make it harder to read and understand the code.
Consider placing each statement on its own line for better readability and maintainability.

# What Does This Check Look For?
This check reports a finding when more than one ABAP statement is found on the same line in the source code.

# Why is This a Problem?
Placing multiple statements on the same line can significantly reduce the readability of ABAP code.
When code is quickly browsed or reviewed, developers might overlook important actions if they are not clearly separated.
This can lead to missed bugs or misunderstood logic, ultimately increasing maintenance costs and the likelihood of errors.

# How Can I Resolve This?
To resolve this issue, place each statement on its own line.

# Examples
## Non-Compliant
```abap
DATA: count TYPE i, idx TYPE i VALUE 30. count = 1. WRITE: / 'Count is ', count.
```
## Compliant
```abap
DATA: count TYPE i.
DATA: idx TYPE i VALUE 30.
count = 1.
WRITE: / 'Count is ', count.
```
