This check detects comparisons with the `NULL` value using the `=` operator.

# Why is This a Problem?
Using the `=` (or `!=`, `<>`) operator to compare a value with `NULL` is most probably a bug since this will always return `NULL` instead of the desired boolean.

# How Can I Resolve This?
To compare a value with `NULL`, you should always use special operators `IS NULL` or `IS NOT NULL`.

## Example (Before)

```oraclesqlplus
IF someVar = NULL ...
```

## Example (After)

```oraclesqlplus
IF someVar IS NULL ...
```

# Where Can I Learn More?

## Guidelines
- [PL/SQL & SQL Coding Guidelines Version 4.0: G-2150: Avoid comparisons with NULL value, consider using IS \[NOT\] NULL.](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.0/4-language-usage/2-variables-and-types/1-general/g-2150/)

## References
- [Oracletutorial: Oracle IS NULL](https://www.oracletutorial.com/oracle-basics/oracle-is-null/)
- [Microsof T-SQL Reference: IS NULL (Transact-SQL)](https://learn.microsoft.com/en-gb/sql/t-sql/queries/is-null-transact-sql)
