Using assignments in places where comparison operators are commonly used can lead to code that is difficult to understand.
Consider using comparison operators (`==`, `!=`, `>`, etc.) in conditional statements and ensure assignments (`=`) are used intentionally.

# What Does This Check Look For?

This check identifies instances where assignment operator are used within conditions or other contexts where a comparison operator is typically expected.

# Why is This a Problem?

Using assignment operators in unexpected places may introduce subtle bugs, as the code is syntactically correct but semantically flawed.
Moreover, it can reduce the readability of the code, making it difficult for others (or even the original developer, at a later time) to understand the intention behind the code.
This is generally considered bad practice, as it can lead to hard-to-spot errors and thus complicates maintenance.

# How Can I Resolve This?

To resolve this issue, separate assignments from conditions.
Perform the assignment before the conditional statement and use a comparison within the condition.
This approach clarifies the code's intent and makes unintended behaviors less likely.

# Examples

## Non-Compliant

```java
if ((value = getValue()) != 0) { // non-compliant: assignment within condition
    // process value
}
```

## Compliant

```java
value = getValue();
if (value != 0) { // compliant: separate assignment and comparison
    // process value
}
```

# Where Can I Learn More?
- [EXP51-J. Do not perform assignments in conditional expressions](https://wiki.sei.cmu.edu/confluence/display/java/EXP51-J.+Do+not+perform+assignments+in+conditional+expressions)