The `ref` keyword indicates that a function argument is passed by reference instead of by value.
### Correct Examples
It is often better to assign a return value:
```cs
// Single return value
var returnValue = PerformOperation(inputValue);

// Multiple return values as tuples (C#7 and later)
(string firstName, string lastName) = OtherOperation(name, returnValue);
```
### Incorrect Examples
```cs
// Single call-by-reference
ChangeInPlace(ref returnValue);

//Multiple call-by-reference
OtherOperation(ref name, ref returnValue);
```
