Potential side effects of operands used in `sizeof()` may have no effect/not be executed which can lead to unintended behaviour.


# What Does This Check Look For?

This check searches for operands inside the sizeof operator
that may lead to side effects on the `sizeof()` evaluation and reports a 
finding when certain operands are found such as `function` calls or operators 
such as `=`, `++`,  `--`, `+=` or `-=`.

# Why is This a Problem?

The operand of a `sizeof()` operator may be either an expression or may specify a type. If the operand
contains an expression like a function call or a variable reassignment, a possible programming error is to expect that expression to be evaluated
when it is actually not evaluated in most circumstances.

The reason for this is that `sizeof()` calls are
usually evaluated at compile time and replaced with a constant.

# How Can I Resolve This?
Extract the variable increment or function call before or after the `sizeof()` call.
This way your guaranteed that your side effect will get executed.


# Examples
## Non-Compliant

```$LANGUAGE
int f(void){
	int i = 0;
	char arr[20];
	int size = sizeof(arr[i++]); //wrong: sizeof expression has side effect
	cout << i; //would output 0 instead of  1
}
```

## Compliant

```$LANGUAGE
int f(void){
	int i = 0;
	char arr[20];
	int size = sizeof(arr[i]);
	i++; 
	cout << i; //would output 1
}
```

# Where Can I Learn More?
- Guideline: MISRA C:2012: 13.6 - The operand of the sizeof operator shall not contain any expression which has potential side effects