Calls to certain functions can introduce security vulnerabilities.
Inspect and validate the necessity and safety of using such functions.

# What Does This Check Look For?

This check identifies calls to function modules that are known to be suspicious or potentially hazardous from a security standpoint.

# Why is This a Problem?

The use of functions like `GUI_UPLOAD`, `GUI_DOWNLOAD`, or `FTP_CONNECT` can lead to vulnerabilities in the application, such as unauthorized access, data leakage, or remote code execution.
These functions often interact with external systems or handle file operations, which are common vectors for security attacks.
Misuse or improper handling of these functions can compromise the security of the entire application.

# How Can I Resolve This?

Review the necessity of using these specific function calls in the given context.
If their use is essential, ensure that proper security measures like input validation, permission checks and logging are implemented, to mitigate potential risks.


# Examples

## Non-Compliant

```ABAP
GUI_UPLOAD( ... ).     "non-compliant: exposes potential file upload vulnerability.
```

## Compliant

```ABAP
"Before calling GUI_UPLOAD, ensure all necessary security checks and validations are in place.
IF authorized_user() AND valid_file(input_file).
    GUI_UPLOAD(...).
ENDIF.
```
