In C type declarations, it is possible to omit the type (implicit type is `int` then).
To improve readability, this implicit typing should be avoided in `typedef` statements.

# Why is This a Problem?
Omitting the type lowers the readability and clarity of the code.

# How Can I Resolve This?
Explicitly state the type of the declaration.

## Example (Before)

```c
typedef temperature;

int main()
{
  temperature t = 20;
  return 0;
}
```

## Example (After)

```c
typedef int temperature;

int main()
{
  temperature t = 20;
  return 0;
}
```