/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestClientHandlerBase;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.VssRestResponse;
import com.microsoft.alm.client.jaxrs.ApiResourceEntityProvider;
import com.microsoft.alm.client.model.VssResourceNotFoundException;
import com.microsoft.alm.client.model.VssServiceException;
import com.microsoft.alm.client.utils.StringUtil;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocation;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocationCollection;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class DefaultRestClientHandler
extends VssRestClientHandlerBase
implements VssRestClientHandler {
    private final Client rsClient;
    private final WebTarget baseTarget;

    public DefaultRestClientHandler(Client rsClient) {
        this.rsClient = rsClient;
        this.baseTarget = (WebTarget)this.rsClient.target(this.getBaseUrl()).register(ApiResourceEntityProvider.class);
    }

    @Override
    public boolean checkConnection() {
        WebTarget optionsTarget = this.baseTarget.path("_apis/connectiondata");
        Invocation.Builder builder = optionsTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        try {
            return builder.build(HttpMethod.GET.getVerb()).submit().get() != null;
        }
        catch (Exception e) {
            this.setLastException(e);
            return false;
        }
    }

    @Override
    protected ApiResourceLocationCollection loadLocations() {
        WebTarget optionsTarget = this.baseTarget.path("_apis");
        Invocation.Builder builder = optionsTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        try {
            return (ApiResourceLocationCollection)builder.async().options(ApiResourceLocationCollection.class).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            this.setLastException((Exception)e.getCause());
        }
        return null;
    }

    @Override
    public <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, String contentMediaType, Map<String, String> queryParameters, String acceptMediaType) {
        Invocation request;
        HttpMethod httpMethod;
        WebTarget target = this.createTarget(locationId, routeValues, queryParameters);
        MediaType acceptType = this.getMediaTypeWithQualityHeaderValue(acceptMediaType, this.negotiateRequestVersion(locationId, version));
        Invocation.Builder requestBuilder = target.request(new MediaType[]{acceptType});
        if (this.shouldOverrideHttpMethod(method)) {
            httpMethod = HttpMethod.POST;
            requestBuilder.header("X-HTTP-Method-Override", (Object)method);
        } else {
            httpMethod = method;
        }
        requestBuilder.header("X-TFS-Version", (Object)this.getClientVersion());
        if (value != null) {
            MediaType contentType = this.getMediaTypeWithQualityHeaderValue(contentMediaType);
            request = requestBuilder.build(httpMethod.getVerb(), Entity.entity(value, (MediaType)contentType));
        } else if (httpMethod == HttpMethod.POST) {
            MediaType contentType = this.getMediaTypeWithQualityHeaderValue("application/json");
            request = requestBuilder.build(httpMethod.getVerb(), Entity.entity((Object)"", (MediaType)contentType));
        } else {
            request = requestBuilder.build(httpMethod.getVerb());
        }
        return new JaxRsRequest(request);
    }

    private WebTarget createTarget(UUID locationId, Map<String, Object> routeValues, Map<String, String> queryParameters) {
        ApiResourceLocation location = this.getLocation(locationId);
        if (location == null) {
            throw new VssResourceNotFoundException(locationId, this.getBaseUrl(), this.getLastException());
        }
        Map<String, Object> dictionary = this.toRouteDictionary(routeValues, location.getArea(), location.getResourceName());
        String routeTemplate = location.getRouteTemplate();
        String actualTemplate = this.removeUndefinedOptionalParameters(routeTemplate, dictionary);
        WebTarget targetTemplate = this.baseTarget.path(actualTemplate);
        WebTarget target = targetTemplate.resolveTemplates(dictionary);
        if (queryParameters != null) {
            for (Map.Entry<String, String> queryParameter : queryParameters.entrySet()) {
                target = target.queryParam(queryParameter.getKey(), new Object[]{queryParameter.getValue()});
            }
        }
        return target;
    }

    private MediaType getMediaTypeWithQualityHeaderValue(String baseMediaType, ApiResourceVersion version) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("api-version", version.toString());
        parameters.put("charset", "UTF-8");
        String[] mediaTypePart = baseMediaType.split("/", 2);
        MediaType mediaType = new MediaType(mediaTypePart[0], mediaTypePart[1], parameters);
        return mediaType;
    }

    private MediaType getMediaTypeWithQualityHeaderValue(String baseMediaType) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("charset", "UTF-8");
        String[] mediaTypePart = baseMediaType.split("/", 2);
        MediaType mediaType = new MediaType(mediaTypePart[0], mediaTypePart[1], parameters);
        return mediaType;
    }

    public static class JaxRsResponse
    implements VssRestResponse {
        private final Response response;

        public JaxRsResponse(Response response) {
            this.response = response;
        }

        @Override
        public boolean isJsonResponse() {
            if (this.response != null && this.response.getMediaType() != null) {
                return StringUtil.startsWithIgnoreCase(this.response.getMediaType().toString(), "application/json");
            }
            return false;
        }

        @Override
        public boolean isProxyAuthRequired() {
            return this.response.getStatusInfo() == Response.Status.PROXY_AUTHENTICATION_REQUIRED;
        }

        @Override
        public boolean isSuccessResponse() {
            return this.response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL;
        }

        @Override
        public <TEntity> TEntity readEntity(Class<TEntity> resultClass) {
            return (TEntity)this.response.readEntity(resultClass);
        }

        @Override
        public <TEntity> TEntity readEntity(TypeReference<TEntity> resultClass) {
            return (TEntity)this.response.readEntity(new GenericType(resultClass.getType()));
        }

        @Override
        public String getHeader(String headerName) {
            MultivaluedMap headers = this.response.getStringHeaders();
            return (String)headers.getFirst((Object)headerName);
        }

        @Override
        public String getStatusText() {
            return this.response.getStatusInfo().getReasonPhrase();
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusInfo().getStatusCode();
        }
    }

    public static class JaxRsRequest
    implements VssRestRequest {
        private final Invocation request;

        public JaxRsRequest(Invocation request) {
            this.request = request;
        }

        @Override
        public VssRestResponse sendRequest() {
            Response response;
            try {
                response = (Response)this.request.submit().get();
            }
            catch (ExecutionException e) {
                throw new VssServiceException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                throw new VssServiceException(e.getMessage(), e);
            }
            return new JaxRsResponse(response);
        }
    }
}

