/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client;

import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.utils.StringUtil;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocation;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocationCollection;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

abstract class VssRestClientHandlerBase
implements VssRestClientHandler {
    private boolean overrideEnabled;
    private ApiResourceLocationCollection resourceLocations;
    private URI baseUrl;
    private Exception lastException;
    private String clientVersion;

    VssRestClientHandlerBase() {
    }

    @Override
    public void init(boolean overrideEnabled, String clientVersion, URI baseUrl) {
        this.overrideEnabled = overrideEnabled;
        this.clientVersion = clientVersion;
        this.baseUrl = baseUrl;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public Exception getLastException() {
        return this.lastException;
    }

    protected void setLastException(Exception e) {
        this.lastException = e;
    }

    protected String getClientVersion() {
        return this.clientVersion;
    }

    protected abstract ApiResourceLocationCollection loadLocations();

    @Override
    public ApiResourceLocationCollection getLocations() {
        if (this.resourceLocations == null) {
            this.resourceLocations = this.loadLocations();
        }
        return this.resourceLocations;
    }

    protected ApiResourceLocation getLocation(UUID locationId) {
        if (this.resourceLocations == null) {
            this.resourceLocations = this.loadLocations();
        }
        if (this.resourceLocations != null) {
            return this.resourceLocations.getLocationById(locationId);
        }
        return null;
    }

    public ApiResourceVersion negotiateRequestVersion(ApiResourceLocation location, ApiResourceVersion version) {
        if (version == null) {
            return VssRestClientHandler.DEFAULT_API_VERSION;
        }
        if (location.getMinVersion().compareTo(version.getApiVersion()) > 0) {
            return null;
        }
        if (location.getMaxVersion().compareTo(version.getApiVersion()) < 0) {
            ApiResourceVersion negotiatedVersion = new ApiResourceVersion(location.getMaxVersion());
            boolean isPreview = location.getReleasedVersion().compareTo(location.getMaxVersion()) < 0;
            negotiatedVersion.setPreview(isPreview);
            return negotiatedVersion;
        }
        int resourceVersion = Math.min(version.getResourceVersion(), location.getResourceVersion());
        ApiResourceVersion negotiatedVersion = new ApiResourceVersion(version.getApiVersion(), resourceVersion);
        if (location.getReleasedVersion().compareTo(version.getApiVersion()) < 0) {
            negotiatedVersion.setPreview(true);
        } else {
            negotiatedVersion.setPreview(version.isPreview());
        }
        return negotiatedVersion;
    }

    protected ApiResourceVersion negotiateRequestVersion(UUID locationId, ApiResourceVersion version) {
        return this.negotiateRequestVersion(this.getLocation(locationId), version);
    }

    protected String removeUndefinedOptionalParameters(String template, Map<String, Object> routeValues) {
        String[] templateParameters = template.split("/");
        ArrayList<String> actualParameters = new ArrayList<String>();
        for (int i = 0; i < templateParameters.length; ++i) {
            String parameter = templateParameters[i];
            if (parameter.startsWith("{")) {
                String name = parameter.startsWith("{*") ? parameter.substring(2, parameter.length() - 1) : parameter.substring(1, parameter.length() - 1);
                if (routeValues.get(name) == null) continue;
                actualParameters.add("{" + name + "}");
                continue;
            }
            actualParameters.add(parameter);
        }
        return StringUtil.join("/", actualParameters);
    }

    protected Map<String, Object> toRouteDictionary(Map<String, Object> routeValues, String areaName, String resourceName) {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        if (routeValues != null) {
            for (Map.Entry<String, Object> e : routeValues.entrySet()) {
                if (e.getValue() == null) continue;
                dictionary.put(e.getKey(), e.getValue());
            }
        }
        if (!dictionary.containsKey("area")) {
            dictionary.put("area", areaName);
        }
        if (!dictionary.containsKey("resource")) {
            dictionary.put("resource", resourceName);
        }
        return dictionary;
    }

    protected boolean shouldOverrideHttpMethod(HttpMethod method) {
        if (this.overrideEnabled) {
            return method.isOverrideable();
        }
        return false;
    }
}

