/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.profile.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.profile.Avatar;
import com.microsoft.alm.visualstudio.services.profile.CreateProfileContext;
import com.microsoft.alm.visualstudio.services.profile.GeoRegion;
import com.microsoft.alm.visualstudio.services.profile.Profile;
import com.microsoft.alm.visualstudio.services.profile.ProfileAttribute;
import com.microsoft.alm.visualstudio.services.profile.ProfileAttributeBase;
import com.microsoft.alm.visualstudio.services.profile.ProfileRegions;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.VssJsonCollectionWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ProfileHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected ProfileHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public void deleteProfileAttribute(String id, String descriptor) {
        UUID locationId = UUID.fromString("1392b6ac-d511-492e-af5b-2263e5545a5d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("descriptor", descriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public ProfileAttribute getProfileAttribute(String id, String descriptor) {
        UUID locationId = UUID.fromString("1392b6ac-d511-492e-af5b-2263e5545a5d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("descriptor", descriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ProfileAttribute.class);
    }

    public ArrayList<ProfileAttribute> getProfileAttributes(String id, String partition, String modifiedSince, String modifiedAfterRevision, Boolean withCoreAttributes, String coreAttributes) {
        UUID locationId = UUID.fromString("1392b6ac-d511-492e-af5b-2263e5545a5d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("partition", partition);
        queryParameters.addIfNotEmpty("modifiedSince", modifiedSince);
        queryParameters.addIfNotEmpty("modifiedAfterRevision", modifiedAfterRevision);
        queryParameters.addIfNotNull("withCoreAttributes", withCoreAttributes);
        queryParameters.addIfNotEmpty("coreAttributes", coreAttributes);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ProfileAttribute>>(){});
    }

    public void setProfileAttribute(ObjectNode container, String id, String descriptor) {
        UUID locationId = UUID.fromString("1392b6ac-d511-492e-af5b-2263e5545a5d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("descriptor", descriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, container, "application/json", queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void setProfileAttributes(VssJsonCollectionWrapper<List<ProfileAttributeBase<Object>>> attributesCollection, String id) {
        UUID locationId = UUID.fromString("1392b6ac-d511-492e-af5b-2263e5545a5d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, attributesCollection, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public Avatar getAvatar(String id, String size, String format) {
        UUID locationId = UUID.fromString("67436615-b382-462a-b659-5367a492fb3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("size", size);
        queryParameters.addIfNotEmpty("format", format);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Avatar.class);
    }

    public Avatar getAvatarPreview(ObjectNode container, String id, String size, String format, String displayName) {
        UUID locationId = UUID.fromString("67436615-b382-462a-b659-5367a492fb3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("size", size);
        queryParameters.addIfNotEmpty("format", format);
        queryParameters.addIfNotEmpty("displayName", displayName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, container, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Avatar.class);
    }

    public void resetAvatar(String id) {
        UUID locationId = UUID.fromString("67436615-b382-462a-b659-5367a492fb3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void setAvatar(ObjectNode container, String id) {
        UUID locationId = UUID.fromString("67436615-b382-462a-b659-5367a492fb3c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, container, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public GeoRegion getGeoRegion(String ipaddress) {
        UUID locationId = UUID.fromString("3bcda9c0-3078-48a5-a1e0-83bd05931ad0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("ipaddress", ipaddress);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, GeoRegion.class);
    }

    public Profile createProfile(CreateProfileContext createProfileContext, Boolean autoCreate) {
        UUID locationId = UUID.fromString("f83735dc-483f-4238-a291-d45f6080a9af");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("autoCreate", autoCreate);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, createProfileContext, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, Profile.class);
    }

    public Profile getProfile(String id, Boolean details, Boolean withAttributes, String partition, String coreAttributes, Boolean forceRefresh) {
        UUID locationId = UUID.fromString("f83735dc-483f-4238-a291-d45f6080a9af");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("details", details);
        queryParameters.addIfNotNull("withAttributes", withAttributes);
        queryParameters.addIfNotEmpty("partition", partition);
        queryParameters.addIfNotEmpty("coreAttributes", coreAttributes);
        queryParameters.addIfNotNull("forceRefresh", forceRefresh);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Profile.class);
    }

    public void updateProfile(Profile profile, String id) {
        UUID locationId = UUID.fromString("f83735dc-483f-4238-a291-d45f6080a9af");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, profile, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public ProfileRegions getRegions() {
        UUID locationId = UUID.fromString("92d8d1c9-26b8-4774-a929-d640a73da524");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ProfileRegions.class);
    }

    public HashSet<String> getSupportedLcids() {
        UUID locationId = UUID.fromString("d5bd1aa6-c269-4bcd-ad32-75fa17475584");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<HashSet<String>>(){});
    }

    public Profile getUserDefaults(Boolean includeAvatar) {
        UUID locationId = UUID.fromString("b583a356-1da7-4237-9f4c-1deb2edbc7e8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeAvatar", includeAvatar);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Profile.class);
    }
}

