/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.checkinpolicies;

import com.microsoft.tfs.core.checkinpolicies.PolicyDefinition;
import com.microsoft.tfs.core.checkinpolicies.PolicySerializationException;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.memento.MementoException;
import com.microsoft.tfs.core.memento.XMLMemento;
import com.microsoft.tfs.util.Check;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class PolicyAnnotation {
    public static final String CHECKIN_POLICY_ANNOTATION_NAME = "TeampriseCheckinPolicies";
    public static final int SUPPORTED_VERSION = 1;
    private static final String ANNOTATION_CHARSET = "UTF-8";
    private static final String ANNOTATION_MEMENTO_NAME = "policy-annotation";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String POLICY_DEFINITION_MEMENTO_NAME = "policy-definition";
    private final PolicyDefinition[] definitions;

    public PolicyAnnotation(PolicyDefinition[] definitions) {
        Check.notNull(definitions, "definitions");
        Check.isTrue(definitions.length > 0, "definitions array cannot be empty");
        this.definitions = definitions;
    }

    public static PolicyAnnotation fromAnnotation(String annotationValue) throws PolicySerializationException {
        XMLMemento annotationMemento;
        Check.notNull(annotationValue, "annotationValue");
        try {
            annotationMemento = XMLMemento.read(new ByteArrayInputStream(annotationValue.getBytes(ANNOTATION_CHARSET)), ANNOTATION_CHARSET);
        }
        catch (MementoException e) {
            throw new PolicySerializationException("Memento exception", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new PolicySerializationException("Encoding not supported", e);
        }
        if (annotationMemento.getName() != ANNOTATION_MEMENTO_NAME) {
            throw new PolicySerializationException(MessageFormat.format("Got unexpected root element {0} instead of expected {1}", annotationMemento.getName(), ANNOTATION_MEMENTO_NAME));
        }
        Integer schemaVersion = annotationMemento.getInteger(VERSION_ATTRIBUTE_NAME);
        if (schemaVersion == null) {
            throw new PolicySerializationException("The policy annotation did not specify a schema version");
        }
        if (schemaVersion != 1) {
            throw new PolicySerializationException(MessageFormat.format("Policy annotation data version {0} can not be read by this annotation serializer.", schemaVersion.toString()));
        }
        Memento[] definitionMementos = annotationMemento.getChildren(POLICY_DEFINITION_MEMENTO_NAME);
        if (definitionMementos.length == 0) {
            throw new PolicySerializationException("Read 0 policy definitions from the annotation. This annotation should be deleted because annotations cannot contain zero policy definitions.");
        }
        PolicyDefinition[] definitions = new PolicyDefinition[definitionMementos.length];
        for (int i = 0; i < definitionMementos.length; ++i) {
            definitions[i] = PolicyDefinition.fromMemento(definitionMementos[i]);
        }
        return new PolicyAnnotation(definitions);
    }

    public String toAnnotationValue() {
        XMLMemento annotationMemento = new XMLMemento(ANNOTATION_MEMENTO_NAME);
        annotationMemento.putInteger(VERSION_ATTRIBUTE_NAME, 1);
        for (int i = 0; i < this.definitions.length; ++i) {
            Memento definitionMemento = annotationMemento.createChild(POLICY_DEFINITION_MEMENTO_NAME);
            this.definitions[i].toMemento(definitionMemento);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            annotationMemento.write(os, ANNOTATION_CHARSET);
            return os.toString(ANNOTATION_CHARSET);
        }
        catch (IOException e) {
            throw new PolicySerializationException("Error serializing definition memento", e);
        }
    }

    public PolicyDefinition[] getDefinitions() {
        return this.definitions;
    }
}

