/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.CommonInformationHelper;
import java.util.Calendar;
import java.util.Comparator;

public class BuildInformationNodeComparer
implements Comparator<IBuildInformationNode> {
    private static BuildInformationNodeComparer INSTANCE;

    public static Comparator<IBuildInformationNode> getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BuildInformationNodeComparer();
        }
        return INSTANCE;
    }

    @Override
    public int compare(IBuildInformationNode x, IBuildInformationNode y) {
        if (x == null && y == null) {
            return 0;
        }
        if (x == null && y != null) {
            return -1;
        }
        if (x != null && y == null) {
            return 1;
        }
        Calendar leftTimestamp = null;
        Calendar rightTimestamp = null;
        if (x.getFields().containsKey("StartTime")) {
            leftTimestamp = CommonInformationHelper.getDateTime(x.getFields(), "StartTime");
        } else if (x.getFields().containsKey("Timestamp")) {
            leftTimestamp = CommonInformationHelper.getDateTime(x.getFields(), "Timestamp");
        }
        if (y.getFields().containsKey("StartTime")) {
            rightTimestamp = CommonInformationHelper.getDateTime(y.getFields(), "StartTime");
        } else if (y.getFields().containsKey("Timestamp")) {
            rightTimestamp = CommonInformationHelper.getDateTime(y.getFields(), "Timestamp");
        }
        if (leftTimestamp != null && rightTimestamp != null) {
            return leftTimestamp.compareTo(rightTimestamp);
        }
        return new Integer(x.getID()).compareTo(y.getID());
    }
}

