/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.utils;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.util.StringUtil;
import java.text.MessageFormat;

public class BuildValidation {
    private static final char[] AGENT_SPECIAL_CHARS = new char[]{'*', '?'};
    private static final char[] DEFINITION_SPECIAL_CHARS = new char[]{'*', '?', '@'};
    private static final char[] ILLEGAL_NTFS_CHARS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '/', ':', '<', '>', '\\', '|'};
    private static final String[] NTFS_RESERVED_FILENAMES = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    public static void checkValidDefinitionName(String name) {
        ValidationResult result = BuildValidation.validateDefinitionName(name);
        if (!result.isValid()) {
            throw new TECoreException(result.getErrorMessage());
        }
    }

    public static boolean isValidDefinitionName(String name) {
        return BuildValidation.validateDefinitionName(name).isValid();
    }

    private static ValidationResult validateDefinitionName(String name) {
        if (name == null || name.length() == 0) {
            return new ValidationResult(Messages.getString("BuildValidation.MustSpecifyNameForBuildDefinition"));
        }
        if (name.length() > 248) {
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildDefinitionNameTooLongMaxCharactersFormat"), name, 248));
        }
        if (BuildValidation.isNTFSReservedName(name)) {
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildDefinitionNameNotValidCannotBeNTFSReservedFormat"), name));
        }
        if (name.endsWith(" ") || name.endsWith(".")) {
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildDefinitionNameNotValidCannotEndSpaceOrPeriodFormat"), name));
        }
        char[] chars = name.toCharArray();
        boolean charsValid = true;
        for (int i = 0; i < chars.length; ++i) {
            int j;
            char c = chars[i];
            for (j = 0; j < ILLEGAL_NTFS_CHARS.length; ++j) {
                if (ILLEGAL_NTFS_CHARS[j] != c) continue;
                charsValid = false;
                break;
            }
            for (j = 0; j < DEFINITION_SPECIAL_CHARS.length; ++j) {
                if (DEFINITION_SPECIAL_CHARS[j] != c) continue;
                charsValid = false;
                break;
            }
            if (charsValid) continue;
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildDefinitionNameContainsInvalidCharactersFormat"), name));
        }
        return new ValidationResult(true);
    }

    public static void checkAgentName(String name) {
        ValidationResult result = BuildValidation.validateAgentName(name);
        if (!result.isValid()) {
            throw new TECoreException(result.getErrorMessage());
        }
    }

    public static boolean isValidAgentName(String name) {
        ValidationResult result = BuildValidation.validateAgentName(name);
        return result.isValid();
    }

    public static void checkValidControllerName(String name, boolean allowWildcards) {
        ValidationResult result = BuildValidation.validateControllerName(name, allowWildcards);
        if (!result.isValid()) {
            throw new TECoreException(result.getErrorMessage());
        }
    }

    public static boolean isValidControllerName(String name, boolean allowWildcards) {
        ValidationResult result = BuildValidation.validateControllerName(name, allowWildcards);
        return result.isValid();
    }

    private static ValidationResult validateControllerName(String name, boolean allowWildcards) {
        if (StringUtil.isNullOrEmpty(name)) {
            return new ValidationResult(false, Messages.getString("BuildValidation.NameRequired"));
        }
        if (name.length() > 248) {
            String format = Messages.getString("BuildValidation.NameTooLongFormat");
            String message = MessageFormat.format(format, name, 259);
            return new ValidationResult(false, message);
        }
        if (BuildValidation.isNTFSReservedName(name)) {
            String format = Messages.getString("BuildValidation.NameReservedFormat");
            String message = MessageFormat.format(format, name);
            return new ValidationResult(false, message);
        }
        if (name.endsWith(" ") || name.endsWith(".")) {
            String format = Messages.getString("BuildValidation.NameTerminationErrorFormat");
            String message = MessageFormat.format(format, name);
            return new ValidationResult(false, message);
        }
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            for (int j = 0; j < ILLEGAL_NTFS_CHARS.length; ++j) {
                if (ILLEGAL_NTFS_CHARS[j] != c) continue;
                String format = Messages.getString("BuildValidation.NameInvalidCharsFormat");
                String message = MessageFormat.format(format, name);
                return new ValidationResult(false, message);
            }
        }
        if (!allowWildcards && Wildcard.isWildcard(name)) {
            String format = Messages.getString("BuildValidation.NameInvalidCharsFormat");
            String message = MessageFormat.format(format, name);
            return new ValidationResult(false, message);
        }
        return new ValidationResult(true);
    }

    private static ValidationResult validateAgentName(String name) {
        if (name == null || name.length() == 0) {
            return new ValidationResult(Messages.getString("BuildValidation.MustSpecifyNameForBuildAgent"));
        }
        if (name.length() > 248) {
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildAgentNameTooLongMaxCharactersFormat"), name, 248));
        }
        if (BuildValidation.isNTFSReservedName(name)) {
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildAGentNameNotValidCannotBeNTFSReservedFormat"), name));
        }
        if (name.endsWith(" ") || name.endsWith(".")) {
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildAgentNameNotValidCannotEndSpaceOrPeriodFormat"), name));
        }
        char[] chars = name.toCharArray();
        boolean charsValid = true;
        for (int i = 0; i < chars.length; ++i) {
            int j;
            char c = chars[i];
            for (j = 0; j < ILLEGAL_NTFS_CHARS.length; ++j) {
                if (ILLEGAL_NTFS_CHARS[j] != c) continue;
                charsValid = false;
                break;
            }
            for (j = 0; j < AGENT_SPECIAL_CHARS.length; ++j) {
                if (AGENT_SPECIAL_CHARS[j] != c) continue;
                charsValid = false;
                break;
            }
            if (charsValid) continue;
            return new ValidationResult(MessageFormat.format(Messages.getString("BuildValidation.BuildAgentNameContainsInvalidCharactersFormat"), name));
        }
        return new ValidationResult(true);
    }

    private static boolean isNTFSReservedName(String name) {
        for (int i = 0; i < NTFS_RESERVED_FILENAMES.length; ++i) {
            if (!NTFS_RESERVED_FILENAMES[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private BuildValidation() {
    }

    private static class ValidationResult {
        private final boolean valid;
        private final String errorMessage;

        public ValidationResult(boolean valid) {
            this(valid, null);
        }

        public ValidationResult(String errorMessage) {
            this(false, errorMessage);
        }

        public ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

