/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceTypes;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.ProjectCollectionCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TFSCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamFoundationServerEntity;
import com.microsoft.tfs.util.GUID;

public class TeamFoundationServerCompatibilityEntity
extends TFSCompatibilityEntity
implements TeamFoundationServerEntity {
    private final Object lock = new Object();
    private ProjectCollectionCompatibilityEntity projectCollection;

    public TeamFoundationServerCompatibilityEntity(TFSCompatibilityEntity parent) {
        super(parent);
    }

    @Override
    public GUID getResourceID() {
        return CatalogResourceTypes.TEAM_FOUNDATION_SERVER_INSTANCE;
    }

    @Override
    public String getDisplayName() {
        return this.getConnection().getName();
    }

    @Override
    public ProjectCollectionEntity[] getProjectCollections() {
        return new ProjectCollectionEntity[]{this.getProjectCollection(this.getConnection().getInstanceID())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectCollectionEntity getProjectCollection(GUID instanceId) {
        if (!this.getConnection().getInstanceID().equals(instanceId)) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.projectCollection == null) {
                this.projectCollection = new ProjectCollectionCompatibilityEntity(this);
            }
            return this.projectCollection;
        }
    }
}

