/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.internal;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntityDataProvider;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;

public class TFSCatalogEntityDataProvider
implements TFSEntityDataProvider {
    private final CatalogNode node;

    public TFSCatalogEntityDataProvider(CatalogNode node) {
        Check.notNull(node, "node");
        this.node = node;
    }

    CatalogNode getCatalogNode() {
        return this.node;
    }

    @Override
    public GUID getResourceTypeID() {
        return new GUID(this.node.getResource().getResourceTypeIdentifier());
    }

    @Override
    public String getDisplayName() {
        return this.node.getResource().getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.node.getResource().getDescription();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.node.getResource().getProperties().get(propertyName);
    }

    @Override
    public ServiceDefinition getServiceReference(String serviceName) {
        return this.node.getResource().getServiceReferences().get(serviceName);
    }
}

