/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.internal;

import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogQueryOptions;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntitySession;
import com.microsoft.tfs.core.clients.framework.configuration.catalog.TFSCatalogEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.OrganizationalRootEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSCatalogEntityFactory;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TFSCatalogEntitySession
implements TFSEntitySession {
    private final TFSConfigurationServer connection;
    private final TFSCatalogEntity[] rootEntities;
    private final Map<String, TFSCatalogEntity> objectCache = new HashMap<String, TFSCatalogEntity>();

    TFSCatalogEntitySession(TFSConfigurationServer connection) {
        this.connection = connection;
        CatalogNode[] rootNodes = connection.getCatalogService().getRootNodes();
        this.rootEntities = new TFSCatalogEntity[rootNodes.length];
        for (int i = 0; i < rootNodes.length; ++i) {
            this.rootEntities[i] = TFSCatalogEntityFactory.newEntity(this, rootNodes[i]);
            this.rootEntities[i].setParent(null);
            this.objectCache.put(rootNodes[i].getFullPath(), this.rootEntities[i]);
        }
    }

    TFSCatalogEntitySession(TFSTeamProjectCollection connection) {
        this(connection.getConfigurationServer());
    }

    public TFSConfigurationServer getConnection() {
        return this.connection;
    }

    @Override
    public OrganizationalRootEntity getOrganizationalRoot() {
        for (TFSCatalogEntity object : this.rootEntities) {
            if (!(object instanceof OrganizationalRootEntity)) continue;
            return (OrganizationalRootEntity)((Object)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TFSEntity loadEntity(String path) {
        TFSCatalogEntity configurationObject;
        Check.notNull(path, "path");
        if (path.length() == 0) {
            return null;
        }
        Map<String, TFSCatalogEntity> map = this.objectCache;
        synchronized (map) {
            if (this.objectCache.containsKey(path)) {
                configurationObject = this.objectCache.get(path);
            } else {
                CatalogNode[] objectNodes = this.connection.getCatalogService().queryNodes(new String[]{path}, null, CatalogQueryOptions.EXPAND_DEPENDENCIES);
                configurationObject = objectNodes.length == 1 ? TFSCatalogEntityFactory.newEntity(this, objectNodes[0]) : null;
                this.objectCache.put(path, configurationObject);
            }
        }
        return configurationObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSEntity loadParent(TFSCatalogEntity childEntity) {
        TFSCatalogEntity parent;
        Check.notNull(childEntity, "childEntity");
        String parentPath = childEntity.getCatalogNode().getParentPath();
        if (parentPath == null || parentPath.length() == 0) {
            return null;
        }
        Map<String, TFSCatalogEntity> map = this.objectCache;
        synchronized (map) {
            if (this.objectCache.containsKey(parentPath)) {
                parent = this.objectCache.get(parentPath);
            } else {
                CatalogNode[] objectNodes = this.connection.getCatalogService().queryNodes(new String[]{parentPath}, null, CatalogQueryOptions.EXPAND_DEPENDENCIES);
                parent = objectNodes.length == 1 ? TFSCatalogEntityFactory.newEntity(this, objectNodes[0]) : null;
                this.objectCache.put(parentPath, parent);
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TFSEntity> loadChildren(TFSCatalogEntity parentEntity) {
        Check.notNull(parentEntity, "parentEntity");
        CatalogNode catalogNode = parentEntity.getCatalogNode();
        CatalogNode[] childNodes = this.connection.getCatalogService().queryNodes(new String[]{catalogNode.getFullPath() + "*"}, null, CatalogQueryOptions.EXPAND_DEPENDENCIES);
        ArrayList<TFSEntity> children = new ArrayList<TFSEntity>();
        for (int i = 0; i < childNodes.length; ++i) {
            TFSCatalogEntity child;
            Map<String, TFSCatalogEntity> map = this.objectCache;
            synchronized (map) {
                child = this.objectCache.get(childNodes[i].getFullPath());
                if (child == null) {
                    child = TFSCatalogEntityFactory.newEntity(this, childNodes[i]);
                    this.objectCache.put(childNodes[i].getFullPath(), child);
                }
            }
            child.setParent(parentEntity);
            children.add(child);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDependencies(TFSCatalogEntity entity, Map<String, TFSEntity> singletonDependencyMap, Map<String, List<TFSEntity>> dependencySetMap, List<TFSEntity> allDependencyList) {
        Check.notNull(entity, "entity");
        CatalogNode catalogNode = entity.getCatalogNode();
        if (catalogNode.getDependencyGroup() != null) {
            HashMap<String, CatalogNode> singletonDependencyNodes = catalogNode.getDependencyGroup().getSingletons();
            for (Map.Entry singletonEntry : singletonDependencyNodes.entrySet()) {
                TFSCatalogEntity singleton;
                String key = (String)singletonEntry.getKey();
                CatalogNode singletonNode = (CatalogNode)singletonEntry.getValue();
                Map<String, TFSCatalogEntity> map = this.objectCache;
                synchronized (map) {
                    singleton = this.objectCache.get(singletonNode.getFullPath());
                    if (singleton == null) {
                        singleton = TFSCatalogEntityFactory.newEntity(this, singletonNode);
                        this.objectCache.put(singletonNode.getFullPath(), singleton);
                    }
                }
                singletonDependencyMap.put(key, singleton);
                if (singleton == null) continue;
                allDependencyList.add(singleton);
            }
            HashMap<String, ArrayList<CatalogNode>> dependencySets = catalogNode.getDependencyGroup().getSets();
            for (Map.Entry setEntry : dependencySets.entrySet()) {
                String key = (String)setEntry.getKey();
                ArrayList<TFSCatalogEntity> setObjects = new ArrayList<TFSCatalogEntity>();
                for (CatalogNode setNode : (ArrayList)setEntry.getValue()) {
                    TFSCatalogEntity setObject;
                    Map<String, TFSCatalogEntity> map = this.objectCache;
                    synchronized (map) {
                        setObject = this.objectCache.get(setNode.getFullPath());
                        if (setObject == null) {
                            setObject = TFSCatalogEntityFactory.newEntity(this, setNode);
                            this.objectCache.put(setNode.getFullPath(), setObject);
                        }
                    }
                    if (setObject == null) continue;
                    setObjects.add(setObject);
                    allDependencyList.add(setObject);
                }
                dependencySetMap.put(key, setObjects);
            }
        }
    }
}

