/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.registration;

import com.microsoft.tfs.core.clients.registration.ArtifactType;
import com.microsoft.tfs.core.clients.registration.OutboundLinkType;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.registration.RegistrationExtendedAttribute;
import com.microsoft.tfs.core.clients.registration.ServerMap;
import com.microsoft.tfs.core.clients.registration.ServiceInterface;
import com.microsoft.tfs.core.clients.registration.internal.RegistrationDataSerializer;
import com.microsoft.tfs.core.clients.registration.internal.RegistrationUtilities;
import com.microsoft.tfs.core.exceptions.mappers.RegistrationExceptionMapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import ms.tfs.services.registration._03._RegistrationSoap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistrationData {
    private static final Log log = LogFactory.getLog(RegistrationData.class);
    private static final String INSTANCE_ID_EXTENDED_ATTRIBUTE_NAME = "InstanceId";
    private static final String OBJECT_NAME = "registration.xml";
    private final Map regEntryCache = new HashMap();
    private final long lastRefreshTimeMillis;
    private final String serverURI;

    public static String makeChildLocationName(URI serverURI, String instanceID) {
        Check.notNull(serverURI, "serverURI");
        Check.notNull(instanceID, "instanceID");
        StringBuffer buffer = new StringBuffer();
        buffer.append(instanceID.toLowerCase());
        buffer.append("_");
        buffer.append(serverURI.getScheme().toLowerCase());
        return buffer.toString();
    }

    public static RegistrationData newFromServer(_RegistrationSoap webService, URI serverURI) {
        RegistrationEntry[] entries;
        Check.notNull(webService, "webService");
        Check.notNull(serverURI, "serverURI");
        try {
            entries = (RegistrationEntry[])WrapperUtils.wrap(RegistrationEntry.class, webService.getRegistrationEntries(""));
        }
        catch (ProxyException e) {
            throw RegistrationExceptionMapper.map(e);
        }
        return new RegistrationData(entries, System.currentTimeMillis(), serverURI.toString());
    }

    public static RegistrationData load(PersistenceStore cacheStore, URI serverURI) {
        Check.notNull(cacheStore, "cacheStore");
        Check.notNull(serverURI, "serverURI");
        ServerMap serverMap = ServerMap.load(cacheStore);
        String uriString = serverURI.toString();
        String instanceID = serverMap.getServerID(uriString);
        if (instanceID == null) {
            return null;
        }
        String childLocationName = RegistrationData.makeChildLocationName(serverURI, instanceID);
        return RegistrationData.load(cacheStore, childLocationName);
    }

    public static RegistrationData load(PersistenceStore cacheStore, String childLocationName) {
        Check.notNull(cacheStore, "cacheStore");
        Check.notNull(childLocationName, "childLocationName");
        PersistenceStore currentStore = cacheStore.getChildStore("TEE-Registration").getChildStore(childLocationName);
        try {
            if (!currentStore.containsItem(OBJECT_NAME)) {
                return null;
            }
            return (RegistrationData)currentStore.retrieveItem(OBJECT_NAME, LockMode.WAIT_FOREVER, null, new RegistrationDataSerializer());
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("unable to load registration data from {0}:{1}", currentStore.toString(), OBJECT_NAME), (Throwable)e);
            return null;
        }
    }

    public RegistrationData(RegistrationEntry[] entries, long lastRefreshTimeMillis, String serverURI) {
        Check.notNull(entries, "entries");
        Check.notNull(serverURI, "serverURI");
        this.lastRefreshTimeMillis = lastRefreshTimeMillis;
        this.serverURI = serverURI;
        for (int i = 0; i < entries.length; ++i) {
            this.regEntryCache.put(entries[i].getType().toLowerCase(), entries[i]);
        }
    }

    public void save(PersistenceStore baseStore, String childLocationName) {
        Check.notNull(baseStore, "baseStore");
        Check.notNull(childLocationName, "childLocationName");
        PersistenceStore currentStore = baseStore.getChildStore("TEE-Registration").getChildStore(childLocationName);
        try {
            currentStore.storeItem(OBJECT_NAME, this, LockMode.WAIT_FOREVER, null, new RegistrationDataSerializer());
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("unable to save registration data to {0}:{1}", currentStore.toString(), OBJECT_NAME), (Throwable)e);
        }
    }

    public boolean isDataStale(long refreshIntervalMillis) {
        long nextRefreshTimeMillis = this.lastRefreshTimeMillis + refreshIntervalMillis;
        long currentTimeMillis = System.currentTimeMillis();
        return currentTimeMillis >= nextRefreshTimeMillis;
    }

    public RegistrationEntry[] getRegistrationEntries(boolean makeCopy) {
        RegistrationEntry[] entries = this.regEntryCache.values().toArray(new RegistrationEntry[this.regEntryCache.size()]);
        if (makeCopy) {
            entries = RegistrationUtilities.copy(entries);
        }
        return entries;
    }

    public RegistrationEntry getRegistrationEntry(String toolID, boolean makeCopy) {
        if (!RegistrationUtilities.isToolType(toolID)) {
            throw new IllegalArgumentException(MessageFormat.format("illegal tool id: [{0}]", toolID));
        }
        RegistrationEntry entry = (RegistrationEntry)this.regEntryCache.get(toolID.toLowerCase());
        if (makeCopy && entry != null) {
            entry = RegistrationUtilities.copy(entry);
        }
        return entry;
    }

    public ServiceInterface[] getServiceInterfaces(String toolID, boolean makeCopy) {
        RegistrationEntry entry = this.getRegistrationEntry(toolID, false);
        if (entry == null) {
            return null;
        }
        ServiceInterface[] serviceInterfaces = entry.getServiceInterfaces();
        if (serviceInterfaces != null && makeCopy) {
            serviceInterfaces = RegistrationUtilities.copy(serviceInterfaces);
        }
        return serviceInterfaces;
    }

    public ServiceInterface getServiceInterface(String toolID, String serviceInterfaceName, boolean makeCopy) {
        Check.notNull(serviceInterfaceName, "serviceInterfaceName");
        ServiceInterface[] serviceInterfaces = this.getServiceInterfaces(toolID, false);
        if (serviceInterfaces == null) {
            return null;
        }
        for (int i = 0; i < serviceInterfaces.length; ++i) {
            if (!serviceInterfaceName.equalsIgnoreCase(serviceInterfaces[i].getName())) continue;
            if (makeCopy) {
                return RegistrationUtilities.copy(serviceInterfaces[i]);
            }
            return serviceInterfaces[i];
        }
        return null;
    }

    public String getServiceInterfaceURL(String toolID, String serviceInterfaceName, boolean relative) {
        ServiceInterface serviceInterface = this.getServiceInterface(toolID, serviceInterfaceName, false);
        if (serviceInterface == null) {
            return null;
        }
        return relative ? serviceInterface.getRelativeURL() : serviceInterface.getURL();
    }

    public ArtifactType[] getArtifactTypes(String toolID, boolean makeCopy) {
        RegistrationEntry entry = this.getRegistrationEntry(toolID, false);
        if (entry == null) {
            return null;
        }
        ArtifactType[] artifactTypes = entry.getArtifactTypes();
        if (artifactTypes != null && makeCopy) {
            artifactTypes = RegistrationUtilities.copy(artifactTypes);
        }
        return artifactTypes;
    }

    public ArtifactType getArtifactType(String toolID, String artifactTypeName, boolean makeCopy) {
        Check.notNull(artifactTypeName, "artifactTypeName");
        ArtifactType[] artifactTypes = this.getArtifactTypes(toolID, false);
        if (artifactTypes == null) {
            return null;
        }
        for (int i = 0; i < artifactTypes.length; ++i) {
            if (!artifactTypeName.equalsIgnoreCase(artifactTypes[i].getName())) continue;
            if (makeCopy) {
                return RegistrationUtilities.copy(artifactTypes[i]);
            }
            return artifactTypes[i];
        }
        return null;
    }

    public OutboundLinkType[] getOutboundLinkTypes(String toolID, String artifactTypeName, boolean makeCopy) {
        ArtifactType artifactType = this.getArtifactType(toolID, artifactTypeName, false);
        if (artifactType == null) {
            return null;
        }
        OutboundLinkType[] outboundLinkTypes = artifactType.getOutboundLinkTypes();
        if (outboundLinkTypes != null && makeCopy) {
            outboundLinkTypes = RegistrationUtilities.copy(outboundLinkTypes);
        }
        return outboundLinkTypes;
    }

    public RegistrationExtendedAttribute[] getExtendedAttributes(String toolID, boolean makeCopy) {
        RegistrationEntry entry = this.getRegistrationEntry(toolID, false);
        if (entry == null) {
            return null;
        }
        RegistrationExtendedAttribute[] extendedAttributes = entry.getRegistrationExtendedAttributes();
        if (extendedAttributes != null && makeCopy) {
            extendedAttributes = RegistrationUtilities.copy(extendedAttributes);
        }
        return extendedAttributes;
    }

    public RegistrationExtendedAttribute getExtendedAttribute(String toolID, String attributeName, boolean makeCopy) {
        Check.notNull(attributeName, "attributeName");
        RegistrationExtendedAttribute[] attributes = this.getExtendedAttributes(toolID, false);
        if (attributes == null) {
            return null;
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributeName.equals(attributes[i].getName())) continue;
            if (makeCopy) {
                return RegistrationUtilities.copy(attributes[i]);
            }
            return attributes[i];
        }
        return null;
    }

    public String getExtendedAttributeValue(String toolID, String attributeName) {
        RegistrationExtendedAttribute attribute2 = this.getExtendedAttribute(toolID, attributeName, false);
        if (attribute2 == null) {
            return null;
        }
        return attribute2.getValue();
    }

    public GUID getInstanceIDExtendedAttributeValue() {
        String value = this.getExtendedAttributeValue("vstfs", INSTANCE_ID_EXTENDED_ATTRIBUTE_NAME);
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return new GUID(value.trim());
    }

    public long getLastRefreshTimeMillis() {
        return this.lastRefreshTimeMillis;
    }

    public String getServerURI() {
        return this.serverURI;
    }
}

