/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent;

import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoundedExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(BoundedExecutor.class);
    private final Executor executor;
    private final Semaphore semaphore;
    private final int maxPermits;

    public BoundedExecutor(Executor executor, int bound) {
        Check.notNull(executor, "executor");
        Check.isTrue(bound > 0, "bound > 0");
        this.executor = executor;
        this.semaphore = new Semaphore(bound);
        this.maxPermits = bound;
        log.trace((Object)MessageFormat.format("constructed with bounds {0}", Integer.toString(bound)));
    }

    @Override
    public void execute(final Runnable command) {
        Check.notNull(command, "command");
        try {
            this.acquire();
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted waiting on semaphore; re-interrupting current thread", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        command.run();
                    }
                    finally {
                        BoundedExecutor.this.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.release();
        }
    }

    private void acquire() throws InterruptedException {
        this.semaphore.acquire();
        log.trace((Object)MessageFormat.format("semaphore acquired: {0}/{1} permits left", Integer.toString(this.semaphore.availablePermits()), Integer.toString(this.maxPermits)));
    }

    private void release() {
        this.semaphore.release();
        log.trace((Object)MessageFormat.format("semaphore released: {0}/{1} permits left", Integer.toString(this.semaphore.availablePermits()), Integer.toString(this.maxPermits)));
    }
}

