/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ExclusionSet;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalItemExclusionsUpdatedListener;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalItemExclusionSet;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalServerInfo;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import com.microsoft.tfs.util.xml.XMLException;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalItemExclusionCache {
    public static final String FILE_NAME = "LocalItemExclusions.config";
    private static final String EXCLUSION_ROOT = "LocalItemExclusions";
    private static final String TEAM_PROJECT_COLLECTION = "TeamProjectCollection";
    private static final String COLLECTION_ID = "id";
    private static final String COLLECTION_URL = "uri";
    private static final Log log = LogFactory.getLog(LocalItemExclusionSet.class);
    private final ReentrantReadWriteLock dataManagementLock = new ReentrantReadWriteLock();
    private final File cacheFile;
    private final boolean cacheEnabled;
    private volatile boolean cacheLoaded = false;
    private final SingleListenerFacade listeners = new SingleListenerFacade(LocalItemExclusionsUpdatedListener.class);
    private final Map<InternalServerInfo, ExclusionSet> exclusions = new TreeMap<InternalServerInfo, ExclusionSet>(new InternalServerInfoGUIDComparator());

    public LocalItemExclusionCache(File cacheFile, boolean cacheEnabled) {
        this.cacheFile = cacheFile;
        this.cacheEnabled = cacheEnabled;
    }

    public void addExclusionsUpdatedListener(LocalItemExclusionsUpdatedListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeExclusionUpdatedListener(LocalItemExclusionsUpdatedListener listener) {
        this.listeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusion(InternalServerInfo serverInfo, String exclusion) {
        Check.notNull(serverInfo, "serverInfo");
        Check.notNullOrEmpty(exclusion, "exclusion");
        this.ensureDiskCacheLoaded();
        boolean somethingRemoved = false;
        try {
            this.dataManagementLock.writeLock().lock();
            ExclusionSet exclusionSet = this.exclusions.get(serverInfo);
            if (exclusionSet != null && (somethingRemoved = exclusionSet.removeExclusion(exclusion))) {
                this.writeCacheToDisk();
            }
        }
        finally {
            if (this.dataManagementLock.isWriteLockedByCurrentThread()) {
                this.dataManagementLock.writeLock().unlock();
            }
        }
        if (somethingRemoved) {
            this.fireExclusionChange(serverInfo.getServerGUID());
        }
    }

    public void setDefaultExclusions(InternalServerInfo serverInfo, String[] exclusions) {
        LocalItemExclusionSet exclusionSet = new LocalItemExclusionSet();
        exclusionSet.setExclusions(exclusions);
        this.setDefaultExclusions(serverInfo, exclusionSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultExclusions(InternalServerInfo serverInfo, LocalItemExclusionSet localItemExclusionSet) {
        Check.notNull(serverInfo, "serverInfo");
        Check.notNull(localItemExclusionSet, "localItemExclusionSet");
        this.ensureDiskCacheLoaded();
        try {
            this.dataManagementLock.writeLock().lock();
            ExclusionSet exclusionSet = this.exclusions.get(serverInfo);
            if (exclusionSet != null) {
                exclusionSet.setDefaultExclusions(localItemExclusionSet);
            } else {
                exclusionSet = new ExclusionSet();
                exclusionSet.setDefaultExclusions(localItemExclusionSet);
                this.exclusions.put(serverInfo, exclusionSet);
            }
            this.writeCacheToDisk();
        }
        finally {
            if (this.dataManagementLock.isWriteLockedByCurrentThread()) {
                this.dataManagementLock.writeLock().unlock();
            }
        }
        this.fireExclusionChange(serverInfo.getServerGUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExclusions(InternalServerInfo serverInfo) {
        Check.notNull(serverInfo, "serverInfo");
        this.ensureDiskCacheLoaded();
        boolean readLockHeld = false;
        try {
            this.dataManagementLock.readLock().lock();
            readLockHeld = true;
            ExclusionSet exclusionSet = this.exclusions.get(serverInfo);
            if (exclusionSet == null) {
                this.dataManagementLock.readLock().unlock();
                readLockHeld = false;
                this.dataManagementLock.writeLock().lock();
                exclusionSet = this.exclusions.get(serverInfo);
                if (exclusionSet == null) {
                    exclusionSet = new ExclusionSet();
                    this.exclusions.put(serverInfo, exclusionSet);
                }
            }
            String[] stringArray = exclusionSet.getExclusions();
            return stringArray;
        }
        finally {
            if (readLockHeld) {
                this.dataManagementLock.readLock().unlock();
            }
            if (this.dataManagementLock.isWriteLockedByCurrentThread()) {
                this.dataManagementLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar getLastDefaultExclusionUpdate(InternalServerInfo serverInfo) {
        Check.notNull(serverInfo, "serverInfo");
        this.ensureDiskCacheLoaded();
        try {
            this.dataManagementLock.readLock().lock();
            ExclusionSet exclusionSet = this.exclusions.get(serverInfo);
            if (exclusionSet != null) {
                Calendar calendar = exclusionSet.getLastDefaultExclusionUpdate();
                return calendar;
            }
            Calendar ret = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            ret.set(1, 0, 1, 0, 0, 0);
            ret.set(14, 0);
            Calendar calendar = ret;
            return calendar;
        }
        finally {
            this.dataManagementLock.readLock().unlock();
        }
    }

    private void ensureDiskCacheLoaded() {
        if (!this.cacheEnabled || this.cacheLoaded) {
            return;
        }
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            this.dataManagementLock.writeLock().lock();
            if (this.cacheLoaded) {
                return;
            }
            try {
                if (this.cacheFile.exists()) {
                    try {
                        Document document = DOMCreateUtils.parseFile(this.cacheFile, "UTF-8");
                        if (document != null) {
                            this.load(document);
                        }
                    }
                    catch (XMLException xmlException) {
                        String format = Messages.getString("LocalItemExclusionCache.InvalidCacheFileFormat");
                        String message = MessageFormat.format(format, this.cacheFile);
                        log.warn((Object)message, (Throwable)xmlException);
                    }
                }
                this.cacheLoaded = true;
            }
            catch (Exception exception) {
                String format = Messages.getString("LocalItemExclusionCache.InvalidCacheFileFormat");
                throw new VersionControlException(MessageFormat.format(format, this.cacheFile), exception);
            }
        }
        finally {
            if (this.dataManagementLock.isWriteLockedByCurrentThread()) {
                this.dataManagementLock.writeLock().unlock();
            }
        }
    }

    private void load(Document document) {
        Element[] tpcElements;
        Element rootElement = DOMUtils.getFirstChildElement(document, EXCLUSION_ROOT);
        Check.notNull(rootElement, "rootElement");
        for (Element tpcElement : tpcElements = DOMUtils.getChildElements(rootElement, TEAM_PROJECT_COLLECTION)) {
            String id = tpcElement.getAttribute(COLLECTION_ID);
            if (id == null) continue;
            GUID collectionID = new GUID(id);
            String url = tpcElement.getAttribute(COLLECTION_URL);
            URI collectionURI = url != null ? URIUtils.newURI(url) : null;
            InternalServerInfo info = new InternalServerInfo(collectionURI, collectionID);
            ExclusionSet exclusionSet = new ExclusionSet(tpcElement);
            this.exclusions.put(info, exclusionSet);
        }
    }

    private void writeCacheToDisk() {
        if (!this.cacheEnabled) {
            return;
        }
        try {
            Document document;
            LocalItemExclusionCache cacheOnDisk = null;
            if (this.cacheFile.exists() && this.cacheFile.isFile()) {
                try {
                    document = DOMCreateUtils.parseFile(this.cacheFile, "UTF-8");
                    cacheOnDisk = new LocalItemExclusionCache(this.cacheFile, true);
                    cacheOnDisk.load(document);
                }
                catch (Exception e) {
                    log.warn((Object)MessageFormat.format("Error reading exclusion file XML from {0}, overwriting", this.cacheFile), (Throwable)e);
                    cacheOnDisk = null;
                }
            }
            document = DOMCreateUtils.newDocument(EXCLUSION_ROOT);
            this.save(cacheOnDisk, DOMUtils.getFirstChildElement(document, EXCLUSION_ROOT));
            DOMSerializeUtils.serializeToStream(document, new FileOutputStream(this.cacheFile), "UTF-8", 2);
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("Error writing exclusion file XML at {0}", this.cacheFile), (Throwable)e);
        }
        this.markClean();
    }

    private void save(LocalItemExclusionCache cacheOnDisk, Element rootElement) {
        if (cacheOnDisk != null) {
            this.merge(cacheOnDisk);
        }
        for (InternalServerInfo key : this.exclusions.keySet()) {
            ExclusionSet value = this.exclusions.get(key);
            Element tpcElement = DOMUtils.appendChild(rootElement, TEAM_PROJECT_COLLECTION);
            tpcElement.setAttribute(COLLECTION_ID, key.getServerGUID().getGUIDString());
            tpcElement.setAttribute(COLLECTION_URL, key.getURI().toString());
            value.save(tpcElement);
        }
    }

    private void merge(LocalItemExclusionCache cacheOnDisk) {
        for (InternalServerInfo key : cacheOnDisk.exclusions.keySet()) {
            ExclusionSet value = cacheOnDisk.exclusions.get(key);
            ExclusionSet cachedExclusionSet = this.exclusions.get(key);
            if (cachedExclusionSet != null) {
                cachedExclusionSet.merge(value);
                continue;
            }
            this.exclusions.put(key, value);
        }
    }

    private void markClean() {
        for (ExclusionSet exclusionSet : this.exclusions.values()) {
            exclusionSet.markClean();
        }
    }

    private void fireExclusionChange(GUID collectionID) {
        ((LocalItemExclusionsUpdatedListener)this.listeners.getListener()).exclusionsUpdated(collectionID);
    }

    private class InternalServerInfoGUIDComparator
    implements Comparator<InternalServerInfo> {
        private InternalServerInfoGUIDComparator() {
        }

        @Override
        public int compare(InternalServerInfo o1, InternalServerInfo o2) {
            return o1.getServerGUID().compareTo(o2.getServerGUID());
        }
    }
}

