/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.InvalidQueuedEditsTableException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryReader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryWriter;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;

public class QueuedEditsTable
extends LocalMetadataTable {
    private final Set<String> queuedEdits = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final short MAGIC = (short)-21657;
    private final short SCHEMA_VERSION1 = 1;

    public QueuedEditsTable(String fileName) throws IOException {
        super(fileName);
    }

    @Override
    protected void load(InputStream is) {
        BinaryReader br = new BinaryReader(is, "UTF-16LE");
        try {
            short magic = br.readInt16();
            if (-21657 != magic) {
                throw new InvalidQueuedEditsTableException();
            }
            byte schemaVersion = br.readByte();
            switch (schemaVersion) {
                case 1: {
                    this.loadFromVersion1(br);
                    break;
                }
                default: {
                    throw new InvalidQueuedEditsTableException();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InvalidQueuedEditsTableException) {
                throw (InvalidQueuedEditsTableException)e;
            }
            throw new InvalidQueuedEditsTableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean save(OutputStream os) throws IOException {
        BinaryWriter bw = new BinaryWriter(os, "UTF-16LE");
        try {
            bw.write((short)-21657);
            this.writeToVersion1(bw);
        }
        finally {
            bw.close();
        }
        return this.queuedEdits.size() > 0;
    }

    private void loadFromVersion1(BinaryReader br) throws IOException {
        int queuedEditCount = br.readInt32();
        for (int i = 0; i < queuedEditCount; ++i) {
            this.queuedEdits.add(br.readString());
        }
    }

    private void writeToVersion1(BinaryWriter bw) throws IOException {
        bw.write((short)1);
        bw.write(this.queuedEdits.size());
        for (String queuedEdit : this.queuedEdits) {
            bw.write(queuedEdit);
        }
    }

    public boolean addQueuedEdit(String localItem) {
        boolean added = this.queuedEdits.add(localItem);
        if (added) {
            this.setDirty(true);
        }
        return added;
    }

    public boolean removeQueuedEdit(String localItem) {
        boolean removed = this.queuedEdits.remove(localItem);
        if (removed) {
            this.setDirty(true);
        }
        return removed;
    }

    public void RemoveQueuedEdits(Iterable<String> localItems) {
        boolean removed = false;
        for (String localItem : localItems) {
            if (!this.queuedEdits.remove(localItem) || removed) continue;
            removed = true;
        }
        if (removed) {
            this.setDirty(true);
        }
    }

    public String[] getQueuedEdits() {
        String[] toReturn = new String[this.queuedEdits.size()];
        this.queuedEdits.toArray(toReturn);
        return toReturn;
    }
}

