/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.offline;

import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OfflineChange {
    private final String localPath;
    private final ItemType serverItemType;
    private final List<OfflineChangeType> changeTypes = new ArrayList<OfflineChangeType>();
    private String sourceLocalPath;

    public OfflineChange(String localPath, OfflineChangeType changeType, ItemType serverItemType) {
        Check.notNull(localPath, "localPath");
        Check.notNull(changeType, "changeType");
        this.localPath = localPath;
        this.serverItemType = serverItemType;
        this.changeTypes.add(changeType);
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public ItemType getServerItemType() {
        return this.serverItemType;
    }

    public String getSourceLocalPath() {
        if (this.sourceLocalPath != null) {
            return this.sourceLocalPath;
        }
        return this.localPath;
    }

    public void setSourceLocalPath(String sourceLocalPath) {
        this.sourceLocalPath = sourceLocalPath;
    }

    public boolean hasChangeType(OfflineChangeType type) {
        Iterator<OfflineChangeType> i = this.changeTypes.iterator();
        while (i.hasNext()) {
            if (i.next() != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasPropertyChange() {
        Iterator<OfflineChangeType> i = this.changeTypes.iterator();
        while (i.hasNext()) {
            if (!i.next().isPropertyChange()) continue;
            return true;
        }
        return false;
    }

    public PropertyValue[] getPropertyValue() {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        Iterator<OfflineChangeType> i = this.changeTypes.iterator();
        while (i.hasNext()) {
            PropertyValue value = i.next().getPropertyValue();
            if (value == null) continue;
            propertyValues.add(value);
        }
        return propertyValues.toArray(new PropertyValue[propertyValues.size()]);
    }

    public OfflineChangeType[] getChangeTypes() {
        return this.changeTypes.toArray(new OfflineChangeType[this.changeTypes.size()]);
    }

    void setChangeType(OfflineChangeType changeType) {
        Check.notNull(changeType, "changeType");
        this.changeTypes.clear();
        this.changeTypes.add(changeType);
    }

    void addChangeType(OfflineChangeType changeType) {
        Check.notNull(changeType, "changeType");
        this.changeTypes.add(changeType);
    }

    public static final OfflineChange[] getChangesByType(OfflineChange[] changes, OfflineChangeType type) {
        ArrayList<OfflineChange> matches = new ArrayList<OfflineChange>();
        for (int i = 0; i < changes.length; ++i) {
            if (!changes[i].hasChangeType(type)) continue;
            matches.add(changes[i]);
        }
        return matches.toArray(new OfflineChange[matches.size()]);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj == this;
    }
}

