/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.path.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemCloakedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemNotMappedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.LocalPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.OnlyOneWorkspaceException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalItemExclusionEvaluator;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PathTranslation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.exceptions.InputValidationException;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class FileSystemWalker {
    private final Workspace workspace;
    private final boolean isRecursive;
    private final boolean includeDirectories;
    private final boolean treatMissingItemsAsFiles;
    private final boolean applyLocalItemExclusions;
    private LocalItemExclusionEvaluator m_localItemExclusionEvaluator;
    private final Set<String> m_appliedExclusions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final Stack<String> dirStack;
    private final String[] fileSpecs;
    private boolean fileSpecIsDir;
    private int fileSpecIndex;
    private String fileNamePattern;
    private String currentFileSpec;
    private boolean fileSpecHasMatch;

    public FileSystemWalker(Workspace workspace, String[] fileSpecs, boolean isRecursive, boolean includeDirectories, boolean treatMissingItemsAsFiles, boolean applyLocalItemExclusions) {
        this.workspace = workspace;
        this.isRecursive = isRecursive;
        this.includeDirectories = includeDirectories;
        this.treatMissingItemsAsFiles = treatMissingItemsAsFiles;
        this.applyLocalItemExclusions = applyLocalItemExclusions;
        this.fileSpecIndex = 0;
        this.fileSpecs = new String[fileSpecs.length];
        System.arraycopy(fileSpecs, 0, this.fileSpecs, 0, fileSpecs.length);
        this.dirStack = new Stack();
        this.nextFileSpec();
    }

    public void walk(FileSystemVisitor visitor) throws OnlyOneWorkspaceException {
        Check.notNull(visitor, "visitor");
        while (this.dirStack.size() > 0) {
            String dirName = this.dirStack.pop();
            dirName = LocalPath.canonicalize(dirName);
            Workspace workspaceForFolder = this.workspace.getClient().getWorkspace(dirName);
            Check.notNull(workspaceForFolder, MessageFormat.format("workspace for {0}", dirName));
            if (null != workspaceForFolder && !workspaceForFolder.equals(this.workspace)) {
                throw new OnlyOneWorkspaceException(workspaceForFolder, dirName);
            }
            if (this.fileSpecIsDir && (this.isRecursive || this.fileNamePattern == null)) {
                this.fileSpecIsDir = false;
                this.fileSpecHasMatch = true;
                if (this.includeDirectories) {
                    visitor.visit(dirName);
                }
            }
            String[] fileNameList = this.fileNamePattern != null ? this.getFullPathsForSubFilesAndDirectories(dirName, this.fileNamePattern) : new String[]{};
            if (null == this.m_localItemExclusionEvaluator && this.workspace.isLocalPathMapped(dirName) && this.applyLocalItemExclusions) {
                this.m_localItemExclusionEvaluator = new LocalItemExclusionEvaluator(this.workspace, dirName);
            }
            Arrays.sort(fileNameList, LocalPath.TOP_DOWN_COMPARATOR);
            for (String fileName : fileNameList) {
                FileSystemAttributes attributes;
                try {
                    attributes = FileSystemUtils.getInstance().getAttributes(fileName);
                    if (!attributes.exists()) {
                        throw new VersionControlException(MessageFormat.format(Messages.getString("FileSystemWalker.FileOrFolderNotFoundFormat"), fileName));
                    }
                }
                catch (Exception exception) {
                    this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)exception));
                    continue;
                }
                if (attributes.isHidden() || attributes.isSystem()) continue;
                boolean isDirectory = attributes.isDirectory();
                if (Wildcard.isWildcard(this.fileNamePattern) && this.isIgnored(fileName, isDirectory) || isDirectory && !this.includeDirectories) continue;
                try {
                    this.checkForIllegalDollarInPath(fileName);
                }
                catch (InputValidationException exception) {
                    if (isDirectory && this.isRecursive) continue;
                    this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)exception));
                    continue;
                }
                this.fileSpecHasMatch = true;
                visitor.visit(fileName);
            }
            if (this.isRecursive) {
                String[] dirs = this.getFullPathsForSubDirectories(dirName);
                Arrays.sort(dirs, LocalPath.TOP_DOWN_COMPARATOR);
                int i = dirs.length;
                while (i-- > 0) {
                    FileSystemAttributes attributes;
                    try {
                        attributes = FileSystemUtils.getInstance().getAttributes(dirs[i]);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (attributes.isHidden() || attributes.isSystem() || attributes.isSymbolicLink() || this.isIgnored(dirs[i], true)) continue;
                    try {
                        this.checkForIllegalDollarInPath(dirs[i]);
                    }
                    catch (InputValidationException exception) {
                        this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)exception));
                        continue;
                    }
                    if (!workspaceForFolder.isLocalPathMapped(dirs[i])) continue;
                    this.dirStack.push(dirs[i]);
                }
            }
            if (this.dirStack.size() != 0) continue;
            if (this.hasNoFileMatches() && this.treatMissingItemsAsFiles) {
                this.fileSpecHasMatch = true;
                visitor.visit(this.currentFileSpec);
            }
            this.nextFileSpec();
        }
    }

    private boolean isIgnored(String fileName, boolean isFolder) {
        AtomicReference<String> appliedExclusion;
        if (BaselineFolder.isPotentialBaselineFolderName(LocalPath.getFileName(fileName))) {
            return true;
        }
        if (null != this.m_localItemExclusionEvaluator && this.m_localItemExclusionEvaluator.isExcluded(fileName, isFolder, appliedExclusion = new AtomicReference<String>(), null)) {
            this.m_appliedExclusions.add(appliedExclusion.get());
            return true;
        }
        return false;
    }

    public String[] getExclusionsApplied() {
        return this.m_appliedExclusions.toArray(new String[this.m_appliedExclusions.size()]);
    }

    private void checkForIllegalDollarInPath(String localPath) throws InputValidationException {
        try {
            LocalPath.checkForIllegalDollarInPath(localPath);
            return;
        }
        catch (InputValidationException inputValidationException) {
            this.workspace.translateLocalPathToServerPath(localPath);
            return;
        }
    }

    private boolean hasNoFileMatches() {
        return this.currentFileSpec != null && !this.fileSpecHasMatch;
    }

    private void checkNoFileMatches() {
        if (this.hasNoFileMatches()) {
            this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)new Exception(MessageFormat.format(Messages.getString("FileSystemWalker.NoFileMatchesFormat"), this.currentFileSpec))));
        }
    }

    private void nextFileSpec() {
        String dirName;
        this.checkNoFileMatches();
        this.fileSpecHasMatch = false;
        this.m_localItemExclusionEvaluator = null;
        while (true) {
            if (this.fileSpecIndex == this.fileSpecs.length) {
                this.currentFileSpec = null;
                return;
            }
            this.currentFileSpec = this.fileSpecs[this.fileSpecIndex];
            ++this.fileSpecIndex;
            FileSystemAttributes attrs = null;
            if (ServerPath.isServerPath(this.currentFileSpec)) {
                PathTranslation translation = this.workspace.translateServerPathToLocalPath(this.currentFileSpec);
                if (translation == null) {
                    this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)new ItemNotMappedException(MessageFormat.format(Messages.getString("VersionControlClient.NoWorkingFolderForFormat"), this.currentFileSpec))));
                    continue;
                }
                if (translation.isCloaked()) {
                    this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)new ItemCloakedException(MessageFormat.format(Messages.getString("FileSystemWalker.ItemIsCloakedFormat"), this.currentFileSpec))));
                    continue;
                }
                this.currentFileSpec = translation.getTranslatedPath();
            } else {
                String nonCanonicalPath = this.currentFileSpec;
                this.currentFileSpec = LocalPath.canonicalize(this.currentFileSpec);
                try {
                    if (!nonCanonicalPath.equals(this.currentFileSpec)) {
                        attrs = null;
                    }
                    this.checkForIllegalDollarInPath(this.currentFileSpec);
                }
                catch (LocalPathFormatException exception) {
                    this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)exception));
                    continue;
                }
            }
            boolean filespecIsDirectory = false;
            if (!ItemPath.isWildcard(this.currentFileSpec)) {
                if (attrs == null) {
                    attrs = FileSystemUtils.getInstance().getAttributes(this.currentFileSpec);
                }
                if (attrs.exists() && !attrs.isSymbolicLink()) {
                    filespecIsDirectory = attrs.isDirectory();
                }
            }
            if (filespecIsDirectory) {
                dirName = this.currentFileSpec;
                this.fileNamePattern = this.isRecursive ? "*" : null;
                this.fileSpecIsDir = true;
            } else {
                if (attrs == null || !attrs.exists()) continue;
                dirName = LocalPath.getParent(this.currentFileSpec);
                this.fileNamePattern = LocalPath.getFileName(this.currentFileSpec);
                this.fileSpecIsDir = false;
            }
            if (Workstation.getCurrent(this.workspace.getClient().getConnection().getPersistenceStoreProvider()).isMapped(dirName)) break;
            this.workspace.getClient().getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)new ItemNotMappedException(MessageFormat.format(Messages.getString("VersionControlClient.NoWorkingFolderForFormat"), dirName))));
        }
        this.dirStack.push(dirName);
    }

    private String[] getFullPathsForSubFilesAndDirectories(String directory, final String pattern) {
        Check.notNull(directory, "directory");
        Check.notNull(pattern, "pattern");
        return this.getAbsolutePaths(new File(directory).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean symlink = FileSystemUtils.getInstance().getAttributes(file.getPath()).isSymbolicLink();
                return (file.isFile() || symlink || file.isDirectory()) && ItemPath.matchesWildcardFile(file.getName(), pattern);
            }
        }));
    }

    private String[] getFullPathsForSubDirectories(String directory) {
        Check.notNull(directory, "directory");
        return this.getAbsolutePaths(new File(directory).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        }));
    }

    private String[] getAbsolutePaths(File[] files) {
        if (files == null) {
            return new String[0];
        }
        String[] paths = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            paths[i] = files[i].getAbsolutePath();
        }
        return paths;
    }

    public static interface FileSystemVisitor {
        public void visit(String var1);
    }
}

