/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.DownloadURL;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.datetime.CalendarUtils;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.Calendar;
import java.util.Comparator;
import java.util.TimeZone;
import ms.tfs.versioncontrol.clientservices._03._GetOperation;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GetOperation
extends WebServiceObjectWrapper
implements Comparable<GetOperation> {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final Log log = LogFactory.getLog(GetOperation.class);
    private static final String EMPTY_SOURCE_SERVER_ITEM = new String(new char[]{'/'});
    private Conflict mergeDetails = null;
    private ProcessType processType = ProcessType.NONE;
    private boolean isSourceLocalCleared = false;
    private boolean isDownloadCompleted = false;
    private byte[] baselineFileGUID;
    private WorkspaceLocalItem localVersionEntry;
    private boolean isOkayToOverwriteExistingLocal;
    private boolean ignore;
    private DownloadURL downloadURLObject;
    public static final Comparator<GetOperation> GET_OPERATION_COMPARATOR = new Comparator<GetOperation>(){

        @Override
        public int compare(GetOperation op1, GetOperation op2) {
            return op1.compareTo(op2);
        }
    };

    public GetOperation() {
        this(new _GetOperation());
    }

    public GetOperation(_GetOperation op) {
        super(op);
        if (EMPTY_SOURCE_SERVER_ITEM.equals(this.getSourceServerItem())) {
            this.setSourceServerItem(this.getTargetServerItem());
        }
        if (CalendarUtils.equalsIgnoreTimeZone(DotNETDate.MIN_CALENDAR, this.getVersionServerDate())) {
            this.setVersionServerDate(DotNETDate.MIN_CALENDAR);
        }
        this.setDownloadURL(op.getDurl());
    }

    public _GetOperation getWebServiceObject() {
        return (_GetOperation)this.webServiceObject;
    }

    public synchronized Conflict getMergeDetails() {
        return this.mergeDetails;
    }

    public synchronized void setMergeDetails(Conflict mergeDetails) {
        this.mergeDetails = mergeDetails;
    }

    public synchronized boolean isNamespaceConflict() {
        if (this.getWebServiceObject().getNmscnflct() == 0) {
            return this.hasConflict() && this.getConflictingItemID() != 0 && this.getConflictingItemID() != this.getItemID();
        }
        return this.getWebServiceObject().getNmscnflct() == 1;
    }

    public synchronized byte[] getHashValue() {
        return this.getWebServiceObject().getHashValue() != null ? (byte[])this.getWebServiceObject().getHashValue().clone() : null;
    }

    public synchronized void setHashValue(byte[] hashValue) {
        this.getWebServiceObject().setHashValue(hashValue != null ? (byte[])hashValue.clone() : null);
    }

    public synchronized ItemType getItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getType());
    }

    public synchronized void setItemType(ItemType type) {
        this.getWebServiceObject().setType(type.getWebServiceObject());
    }

    public synchronized int getItemID() {
        return this.getWebServiceObject().getItemid();
    }

    public synchronized void setItemID(int id) {
        this.getWebServiceObject().setItemid(id);
    }

    public synchronized String getDownloadURL() {
        return this.getWebServiceObject().getDurl();
    }

    public synchronized String getSourceServerItem() {
        return this.getWebServiceObject().getSitem();
    }

    public synchronized void setSourceServerItem(String item) {
        this.getWebServiceObject().setSitem(item);
    }

    public synchronized int getEncoding() {
        return this.getWebServiceObject().getEnc();
    }

    public synchronized void setEncoding(int encoding) {
        this.getWebServiceObject().setEnc(encoding);
    }

    public synchronized String getCurrentLocalItem() {
        if (this.isSourceLocalCleared) {
            return null;
        }
        return LocalPath.tfsToNative(this.getWebServiceObject().getSlocal());
    }

    public synchronized String getSourceLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getSlocal());
    }

    public synchronized void setSourceLocalItem(String item) {
        this.getWebServiceObject().setSlocal(LocalPath.nativeToTFS(item));
    }

    public synchronized String getTargetLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getTlocal());
    }

    public synchronized void setTargetLocalItem(String item) {
        this.getWebServiceObject().setTlocal(LocalPath.nativeToTFS(item));
    }

    public synchronized String getTargetServerItem() {
        return this.getWebServiceObject().getTitem();
    }

    public synchronized void setTargetServerItem(String item) {
        this.getWebServiceObject().setTitem(item);
    }

    public synchronized int getVersionServer() {
        return this.getWebServiceObject().getSver();
    }

    public synchronized void setVersionServer(int version) {
        this.getWebServiceObject().setSver(version);
    }

    public synchronized int getVersionLocal() {
        return this.getWebServiceObject().getLver();
    }

    public synchronized void setVersionLocal(int version) {
        this.getWebServiceObject().setLver(version);
    }

    public synchronized Calendar getVersionServerDate() {
        return this.getWebServiceObject().getVsd();
    }

    public synchronized void setVersionServerDate(Calendar value) {
        this.getWebServiceObject().setVsd(value);
    }

    public synchronized int getDeletionID() {
        return this.getWebServiceObject().getDid();
    }

    public synchronized void setDeletionID(int did) {
        this.getWebServiceObject().setDid(did);
    }

    public synchronized ChangeType getChangeType() {
        return new ChangeType(this.getWebServiceObject().getChg(), this.getWebServiceObject().getChgEx());
    }

    public synchronized void setChangeType(ChangeType changeType) {
        this.getWebServiceObject().setChg(changeType.getWebServiceObject());
        this.getWebServiceObject().setChgEx(changeType.getWebServiceObjectExtendedFlags());
    }

    public synchronized ChangeType getEffectiveChangeType() {
        ChangeType changeType = this.getChangeType();
        if (this.isUndo()) {
            if (changeType.contains(ChangeType.ADD)) {
                return changeType;
            }
            if (changeType.contains(ChangeType.BRANCH)) {
                return ChangeType.BRANCH;
            }
            return ChangeType.NONE;
        }
        return changeType;
    }

    public synchronized LockLevel getLockLevel() {
        return LockLevel.fromWebServiceObject(this.getWebServiceObject().getLock());
    }

    public synchronized void setLockLevel(LockLevel lock) {
        this.getWebServiceObject().setLock(lock != null ? lock.getWebServiceObject() : null);
    }

    public synchronized int getPendingChangeID() {
        return this.getWebServiceObject().getPcid();
    }

    public synchronized void setPendingChangeID(int pcid) {
        this.getWebServiceObject().setPcid(pcid);
    }

    public synchronized void setDownloadURL(String url) {
        this.getWebServiceObject().setDurl(url);
        this.downloadURLObject = new DownloadURL(url);
    }

    public synchronized boolean isLatest() {
        return this.getWebServiceObject().isIl();
    }

    public boolean hasPendingChange() {
        return this.getPendingChangeID() != 0;
    }

    public synchronized boolean hasConflict() {
        return this.getWebServiceObject().isCnflct();
    }

    public synchronized void setHasConflict(boolean conflict) {
        this.getWebServiceObject().setCnflct(conflict);
    }

    public synchronized ChangeType getConflictingChangeType() {
        return new ChangeType(this.getWebServiceObject().getCnflctchg(), this.getWebServiceObject().getCnflctchgEx());
    }

    public synchronized void setConflictingChangeType(ChangeType changeType) {
        this.getWebServiceObject().setCnflctchg(changeType.getWebServiceObject());
    }

    public synchronized int getConflictingItemID() {
        return this.getWebServiceObject().getCnflctitemid();
    }

    public synchronized ProcessType getType() {
        return this.processType;
    }

    public synchronized void setProcessType(ProcessType processType) {
        this.processType = processType;
    }

    public synchronized boolean isUndo() {
        return this.getType() == ProcessType.UNDO;
    }

    public synchronized boolean isDelete() {
        return this.getWebServiceObject().getTlocal() == null;
    }

    public synchronized boolean isNewContentNeeded() {
        if (!(this.getDownloadURL() != null || this.isUndo() && null != this.getBaselineFileGUID())) {
            return false;
        }
        ChangeType pendingChange = this.getChangeType();
        boolean newContentNeeded = this.isUndo() && (pendingChange.contains(ChangeType.EDIT) || pendingChange.contains(ChangeType.DELETE)) && !pendingChange.contains(ChangeType.ADD) && !pendingChange.contains(ChangeType.BRANCH) ? true : this.getVersionLocal() != this.getVersionServer() || this.getCurrentLocalItem() == null && this.getTargetLocalItem() != null;
        Check.isTrue(!newContentNeeded || null != this.getDownloadURL() || this.isUndo() && null != this.getBaselineFileGUID(), "!newContentNeeded || null != this.getDownloadURL() || (isUndo() && null != getBaselineFileGUID())");
        return newContentNeeded;
    }

    public synchronized boolean isCaseChangingRename() {
        String targetFile;
        String sourceFile;
        String sourceLocalItem = this.getCurrentLocalItem();
        String targetLocalItem = this.getTargetLocalItem();
        return sourceLocalItem != null && targetLocalItem != null && LocalPath.equals(LocalPath.getDirectory(sourceLocalItem), LocalPath.getDirectory(targetLocalItem)) && (sourceFile = LocalPath.getFileName(sourceLocalItem)).equalsIgnoreCase(targetFile = LocalPath.getFileName(targetLocalItem)) && !sourceFile.equals(targetFile);
    }

    public synchronized void clearLocalItem() {
        this.isSourceLocalCleared = true;
    }

    public synchronized boolean isDownloadCompleted() {
        return this.isDownloadCompleted;
    }

    public synchronized void setDownloadCompleted(boolean completed) {
        this.isDownloadCompleted = completed;
    }

    public synchronized byte[] getBaselineFileGUID() {
        return this.baselineFileGUID;
    }

    public synchronized void setBaselineFileGUID(byte[] guid) {
        this.baselineFileGUID = guid;
    }

    public synchronized WorkspaceLocalItem getLocalVersionEntry() {
        return this.localVersionEntry;
    }

    public synchronized void setLocalVersionEntry(WorkspaceLocalItem entry) {
        this.localVersionEntry = entry;
    }

    public synchronized boolean isOkayToOverwriteExistingLocal() {
        return this.isOkayToOverwriteExistingLocal;
    }

    public synchronized void setOkayToOverwriteExistingLocal(boolean value) {
        this.isOkayToOverwriteExistingLocal = value;
    }

    public synchronized DownloadSpec createDownloadSpec() {
        return new DownloadSpec(this.getDownloadURL());
    }

    public PropertyValue[] getPropertyValues() {
        return PropertyUtils.selectUnique((PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getPropertyValues()));
    }

    public void setPropertyValues(PropertyValue[] propertyValues) {
        this.getWebServiceObject().setPropertyValues((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, propertyValues));
    }

    @Override
    public synchronized int compareTo(GetOperation other) {
        if (this == other) {
            return 0;
        }
        String thisTargetServerItem = this.getTargetServerItem();
        String otherTargetServerItem = other.getTargetServerItem();
        if (thisTargetServerItem != null && otherTargetServerItem != null) {
            String thisFileName = ServerPath.getFileName(thisTargetServerItem);
            String thisParent = ServerPath.getParent(thisTargetServerItem);
            if (thisFileName.equals(".tpattributes") && ServerPath.isChild(thisParent, otherTargetServerItem)) {
                return -1;
            }
            String otherFileName = ServerPath.getFileName(otherTargetServerItem);
            String otherParent = ServerPath.getParent(otherTargetServerItem);
            if (otherFileName.equals(".tpattributes") && ServerPath.isChild(otherParent, thisTargetServerItem)) {
                return 1;
            }
            int res = ServerPath.compareTopDown(thisTargetServerItem, otherTargetServerItem);
            if (res != 0) {
                return res;
            }
        }
        return this.getItemID() - other.getItemID();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o == null || !(o instanceof GetOperation)) {
            return false;
        }
        return this.compareTo((GetOperation)o) == 0;
    }

    @Override
    public synchronized int hashCode() {
        int c = this.getItemID();
        String targetServerItem = this.getTargetServerItem();
        if (!StringUtil.isNullOrEmpty(targetServerItem)) {
            c = c << 7 | targetServerItem.hashCode();
        }
        return c;
    }

    public void setIgnore(boolean value) {
        this.ignore = value;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isContentDestroyed() {
        return this.downloadURLObject.isContentDestroyed();
    }
}

