/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkDescriptionUpdater;
import com.microsoft.tfs.core.clients.workitem.internal.link.LinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RelatedLinkImpl;
import com.microsoft.tfs.core.clients.workitem.link.DescriptionUpdateErrorCallback;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkUtils;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameter;
import com.microsoft.tfs.core.clients.workitem.query.BatchReadParameterCollection;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RelatedLinkDescriptionUpdater
implements LinkDescriptionUpdater {
    private static final Log log = LogFactory.getLog(RelatedLinkDescriptionUpdater.class);
    private final DescriptionUpdateErrorCallback errorCallback;
    private final WITContext witContext;
    private final String[] fieldReferenceNames;
    private final Map idsToLinks = new HashMap();

    public RelatedLinkDescriptionUpdater(String[] fieldReferenceNames, DescriptionUpdateErrorCallback errorCallback, WITContext witContext) {
        this.errorCallback = errorCallback;
        this.witContext = witContext;
        this.fieldReferenceNames = fieldReferenceNames;
    }

    @Override
    public void addLinkToBeUpdated(LinkImpl link) {
        Integer id = new Integer(((RelatedLink)((Object)link)).getTargetWorkItemID());
        if (!this.idsToLinks.containsKey(id)) {
            this.idsToLinks.put(id, new ArrayList());
        }
        ArrayList links = (ArrayList)this.idsToLinks.get(id);
        links.add(link);
    }

    @Override
    public void run() {
        if (this.idsToLinks.size() == 0) {
            return;
        }
        BatchReadParameterCollection batchReadParams = new BatchReadParameterCollection();
        for (Integer id : this.idsToLinks.keySet()) {
            batchReadParams.add(new BatchReadParameter(id));
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT ");
            for (int i = 0; i < this.fieldReferenceNames.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("[");
                sb.append(this.fieldReferenceNames[i]);
                sb.append("]");
            }
            sb.append(" FROM WorkItems");
            WorkItemCollection queryResults = this.witContext.getClient().query(sb.toString(), batchReadParams);
            for (int i = 0; i < queryResults.size(); ++i) {
                WorkItem workItem = queryResults.getWorkItem(i);
                Integer id = new Integer(workItem.getFields().getID());
                String description = WorkItemLinkUtils.buildDescriptionFromWorkItem(workItem);
                ArrayList links = (ArrayList)this.idsToLinks.get(id);
                for (int linkIndex = 0; linkIndex < links.size(); ++linkIndex) {
                    RelatedLinkImpl relatedLink = (RelatedLinkImpl)links.get(linkIndex);
                    relatedLink.setDescription(description);
                    relatedLink.setWorkItem(workItem);
                    for (int j = 0; j < this.fieldReferenceNames.length; ++j) {
                        workItem.getFields().getField(this.fieldReferenceNames[j]).getValue();
                    }
                }
            }
        }
        catch (Throwable t) {
            if (this.errorCallback != null) {
                this.errorCallback.onDescriptionUpdateError(t);
            }
            log.error((Object)t);
        }
    }
}

