/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.impl;

import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.RulesTable;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.impl.BaseMetadataDAO;
import com.microsoft.tfs.core.clients.workitem.internal.rules.Rule;
import com.microsoft.tfs.core.clients.workitem.internal.rules.RuleResultHandler;
import java.text.MessageFormat;
import java.util.ArrayList;

public class RulesTableImpl
extends BaseMetadataDAO
implements RulesTable {
    @Override
    public int getWorkItemFormID(int teamProjectId, String workItemTypeName) {
        int workItemTypeNameConstID = this.getMetadata().getConstantsTable().getIDByConstant(workItemTypeName);
        String sql = "select ThenConstID from Rules where RULES.fDeleted = 0 AND AreaID = ? AND ThenFldID = ? AND IfConstID = ?";
        Integer result = this.getConnection().createStatement("select ThenConstID from Rules where RULES.fDeleted = 0 AND AreaID = ? AND ThenFldID = ? AND IfConstID = ?").executeIntQuery(new Object[]{new Integer(teamProjectId), new Integer(-14), new Integer(workItemTypeNameConstID)});
        if (result == null) {
            throw new RuntimeException(MessageFormat.format("unable to find a form for work item type [{0}] project [{1}]", workItemTypeName, Integer.toString(teamProjectId)));
        }
        return result;
    }

    @Override
    public Rule[] getRulesForAreaNode(int areaId) {
        return this.runRuleQuery("where AreaID = ? and fDeleted = 0", new Object[]{new Integer(areaId)});
    }

    @Override
    public Rule[] getRulesForThenFieldID(int fieldId) {
        return this.runRuleQuery("where ThenFldID = ?", new Object[]{new Integer(fieldId)});
    }

    private Rule[] runRuleQuery(String queryWhereFragment, Object[] parameters) {
        String sql = "select AreaID,Cachestamp,fDeleted,Fld1ID,Fld1IsConstID,Fld1WasConstID,Fld2ID,Fld2IsConstID,Fld2WasConstID,Fld3ID,Fld3IsConstID,Fld3WasConstID,Fld4ID,Fld4IsConstID,Fld4WasConstID,If2ConstID,If2FldID,IfConstID,IfFldID,ObjectTypeScopeID,PersonID,RootTreeID,RuleFlags1,RuleFlags2,RuleID,ThenConstID,ThenFldID from Rules " + queryWhereFragment;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        RuleResultHandler handler = new RuleResultHandler(rules);
        this.getConnection().createStatement(sql).executeQuery(parameters, handler);
        return rules.toArray(new Rule[0]);
    }
}

