/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.fields.FieldUsages;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.query.SortField;
import com.microsoft.tfs.core.clients.workitem.query.SortFieldList;
import com.microsoft.tfs.core.clients.workitem.query.SortType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import ms.tfs.workitemtracking.clientservices._03._QuerySortOrderEntry;

public class SortFieldListImpl
implements SortFieldList {
    private final WITContext context;
    private final List<SortField> sortFields = new ArrayList<SortField>();
    private final List<Integer> ids = new ArrayList<Integer>();

    public SortFieldListImpl(WITContext context) {
        this.context = context;
    }

    @Override
    public void clear() {
        this.sortFields.clear();
        this.ids.clear();
    }

    @Override
    public boolean add(FieldDefinition fieldDefinition, SortType sortType) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("fieldDefinition must not be null");
        }
        if (!fieldDefinition.isSortable()) {
            throw new IllegalArgumentException(MessageFormat.format("fieldDefinition [{0}] is not sortable", fieldDefinition));
        }
        if (!this.ids.contains(new Integer(fieldDefinition.getID()))) {
            this.sortFields.add(new SortField(fieldDefinition, sortType));
            this.ids.add(new Integer(fieldDefinition.getID()));
            return true;
        }
        return false;
    }

    @Override
    public boolean add(String fieldName, SortType sortType) {
        return this.add(this.context.getClient().getFieldDefinitions().get(fieldName), sortType);
    }

    @Override
    public SortField get(int index) {
        return this.sortFields.get(index);
    }

    @Override
    public int indexOf(FieldDefinition fieldDefinition) {
        return this.ids.indexOf(new Integer(fieldDefinition.getID()));
    }

    @Override
    public boolean remove(FieldDefinition fieldDefinition) {
        int ix = this.indexOf(fieldDefinition);
        if (ix != -1) {
            this.ids.remove(ix);
            this.sortFields.remove(ix);
            return true;
        }
        return false;
    }

    @Override
    public void insert(int ix, FieldDefinition fieldDefinition, SortType sortType) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("fieldDefinition must not be null");
        }
        if (this.indexOf(fieldDefinition) != -1) {
            throw new IllegalArgumentException(MessageFormat.format("field definition [{0}] already exists in this SortFieldList", Integer.toString(fieldDefinition.getID())));
        }
        if (!fieldDefinition.isSortable()) {
            throw new IllegalArgumentException(MessageFormat.format("fieldDefinition [{0}] is not sortable", fieldDefinition));
        }
        this.sortFields.add(ix, new SortField(fieldDefinition, sortType));
        this.ids.add(ix, new Integer(fieldDefinition.getID()));
    }

    @Override
    public int getSize() {
        return this.sortFields.size();
    }

    public _QuerySortOrderEntry[] getSortOrderEntries() {
        _QuerySortOrderEntry[] entries = new _QuerySortOrderEntry[this.sortFields.size()];
        for (int i = 0; i < this.sortFields.size(); ++i) {
            SortField sortField = this.sortFields.get(i);
            entries[i] = new _QuerySortOrderEntry(sortField.getFieldDefinition().getReferenceName(), sortField.getSortType() == SortType.ASCENDING);
        }
        return entries;
    }

    public _QuerySortOrderEntry[] getLinksSortOrder(boolean isTreeQuery) {
        String columnName;
        ArrayList<_QuerySortOrderEntry> list = new ArrayList<_QuerySortOrderEntry>();
        if (this.sortFields.size() == 0 || this.sortFields.size() == 1 && this.sortFields.get(0).getFieldDefinition().getID() == -3 && (!isTreeQuery || this.sortFields.get(0).getSortType() == SortType.ASCENDING)) {
            return new _QuerySortOrderEntry[0];
        }
        if (isTreeQuery) {
            return this.getSortOrderEntries();
        }
        boolean includesId = false;
        for (SortField field : this.sortFields) {
            if (field.getFieldDefinition().getUsage() == FieldUsages.WORK_ITEM) {
                list.add(this.getLinkSortOrder(field, "lhs"));
            }
            if (field.getFieldDefinition().getID() != -3) continue;
            includesId = true;
        }
        if (!includesId) {
            columnName = "[lhs].[System.Id]";
            list.add(new _QuerySortOrderEntry("[lhs].[System.Id]", true));
        }
        for (SortField field : this.sortFields) {
            FieldDefinition fd = field.getFieldDefinition();
            if (fd.getUsage() == FieldUsages.WORK_ITEM) {
                list.add(this.getLinkSortOrder(field, "rhs"));
                continue;
            }
            if (fd.getUsage() != FieldUsages.WORK_ITEM_LINK) continue;
            list.add(this.getLinkSortOrder(field, "links"));
        }
        if (!includesId) {
            columnName = "[rhs].[System.Id]";
            list.add(new _QuerySortOrderEntry("[rhs].[System.Id]", true));
        }
        return list.toArray(new _QuerySortOrderEntry[list.size()]);
    }

    private _QuerySortOrderEntry getLinkSortOrder(SortField field, String prefix) {
        String columnName = "[" + prefix + "].[" + field.getFieldDefinition().getReferenceName() + "]";
        return new _QuerySortOrderEntry(columnName, field.getSortType() == SortType.ASCENDING);
    }
}

