/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.InternalWorkItemUtils;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseRowSetHandler
implements RowSetParseHandler {
    private final Map<String, Integer> columnNamesToIndexes = new HashMap<String, Integer>();
    private int currentColumnIndex;
    private String[] currentRowValues;
    private String tableName;
    private final SimpleDateFormat dateFormat = InternalWorkItemUtils.newMetadataDateFormat();

    protected abstract void doHandleRow();

    @Override
    public void handleBeginParsing() {
        this.currentColumnIndex = 0;
    }

    @Override
    public void handleTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void handleColumn(String name, String type) {
        this.columnNamesToIndexes.put(name, new Integer(this.currentColumnIndex));
        ++this.currentColumnIndex;
    }

    @Override
    public void handleFinishedColumns() {
    }

    @Override
    public void handleRow(String[] rowValues) {
        this.currentRowValues = rowValues;
        this.doHandleRow();
    }

    @Override
    public void handleEndParsing() {
    }

    protected Date getDateValue(String columnName) {
        String value = this.getStringValue(columnName);
        if ("9999-01-01T00:00:00.000".equals(value)) {
            return null;
        }
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(MessageFormat.format("the value [{0}] from column [{1}] in table [{2}] was not parsable to an date", value, columnName, this.tableName), ex);
        }
    }

    protected int getIntValue(String columnName) {
        String value = this.getStringValue(columnName);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(MessageFormat.format("the value [{0}] from column [{1}] in table [{2}] was not parsable to an int", value, columnName, this.tableName), ex);
        }
    }

    protected long getLongValue(String columnName) {
        String value = this.getStringValue(columnName);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(MessageFormat.format("the value [{0}] from column [{1}] in table [{2}] was not parsable to a long", value, columnName, this.tableName), ex);
        }
    }

    protected boolean getBooleanValue(String columnName) {
        String value = this.getStringValue(columnName);
        return "true".equalsIgnoreCase(value);
    }

    protected String getStringValue(String columnName) {
        if (!this.columnNamesToIndexes.containsKey(columnName)) {
            throw new IllegalArgumentException(MessageFormat.format("the column name [{0}] was not encountered in the table [{1}] - columns are: {2}", columnName, this.tableName, this.columnNamesToIndexes.keySet()));
        }
        int index = this.columnNamesToIndexes.get(columnName);
        return this.currentRowValues[index];
    }
}

