/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import java.util.ArrayList;
import java.util.List;

public class GetResultsRowSetHandler
implements RowSetParseHandler {
    private final List<String> columns = new ArrayList<String>();
    private final WorkItemImpl workItem;
    private boolean parsedRow;

    public GetResultsRowSetHandler(WorkItemImpl workItem) {
        this.workItem = workItem;
    }

    @Override
    public void handleBeginParsing() {
        this.columns.clear();
        this.parsedRow = false;
    }

    @Override
    public void handleTableName(String tableName) {
    }

    @Override
    public void handleColumn(String name, String type) {
        this.columns.add(name);
    }

    @Override
    public void handleFinishedColumns() {
    }

    @Override
    public void handleRow(String[] rowValues) {
        if (this.parsedRow) {
            throw new IllegalStateException("unexpected multiple rows in WorkItemInfo rowset");
        }
        this.parsedRow = true;
        for (int i = 0; i < rowValues.length; ++i) {
            String fieldReferenceName = this.columns.get(i);
            this.workItem.getFieldsInternal().addOriginalFieldValueFromServer(fieldReferenceName, rowValues[i], false);
        }
    }

    @Override
    public void handleEndParsing() {
    }

    public boolean parsedRow() {
        return this.parsedRow;
    }
}

