/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rules;

import com.microsoft.tfs.core.clients.workitem.fields.AllowedValuesCollection;
import com.microsoft.tfs.core.clients.workitem.fields.ValuesCollection;
import com.microsoft.tfs.core.clients.workitem.internal.fields.AllowedValuesCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.ValuesCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IFieldPickListSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FieldPickListSupport
implements IFieldPickListSupport {
    private static final Log log = LogFactory.getLog(FieldPickListSupport.class);
    private final String debuggingIdentifier;
    private Set<String> allowed;
    private Set<String> prohibited;
    private Set<String> suggested;
    private AllowedValuesCollection allowedValues;
    private ValuesCollection prohibitedValues;
    private final int psType;

    public FieldPickListSupport(int psType, String debuggingIdentifier) {
        this.psType = psType;
        this.debuggingIdentifier = debuggingIdentifier;
    }

    @Override
    public void reset() {
        this.allowed = null;
        this.prohibited = null;
        this.suggested = null;
        this.allowedValues = null;
        this.prohibitedValues = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("{0}: reset picklist", this.debuggingIdentifier));
        }
    }

    @Override
    public void addProhibitedValues(Collection<String> values) {
        if (this.prohibited == null) {
            this.prohibited = new HashSet<String>();
        }
        this.prohibited.addAll(values);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("{0}: added {1} prohibited value(s) to picklist, prohibited size now = {2}", this.debuggingIdentifier, values.size(), this.prohibited.size()));
        }
    }

    @Override
    public void addAllowedValues(Collection<String> values) {
        if (this.allowed == null) {
            this.allowed = new HashSet<String>();
            this.allowed.addAll(values);
        } else {
            this.allowed.retainAll(values);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("{0}: added {1} allowed value(s) to picklist, allowed size now = {2}", this.debuggingIdentifier, values.size(), this.allowed.size()));
        }
    }

    @Override
    public void addSuggestedValues(Collection<String> values) {
        if (this.suggested == null) {
            this.suggested = new HashSet<String>();
        }
        this.suggested.addAll(values);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("{0}: added {1} suggested value(s) to picklist, suggested size now = {2}", this.debuggingIdentifier, values.size(), this.suggested.size()));
        }
    }

    public ValuesCollection getProhibitedValues() {
        if (this.prohibitedValues == null) {
            ArrayList<String> prohibitedList = new ArrayList<String>();
            if (this.prohibited != null) {
                prohibitedList.addAll(this.prohibited);
            }
            String[] values = prohibitedList.toArray(new String[prohibitedList.size()]);
            this.prohibitedValues = new ValuesCollectionImpl(values, this.psType);
        }
        return this.prohibitedValues;
    }

    public AllowedValuesCollection getAllowedValues() {
        if (this.allowedValues == null) {
            ArrayList<String> pickList = new ArrayList<String>();
            if (this.suggested == null && this.allowed == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("{0}: computed non-existing picklist, since suggested and allowed are null", this.debuggingIdentifier));
                }
            } else {
                if (this.suggested != null) {
                    pickList.addAll(this.suggested);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)MessageFormat.format("{0}: computing picklist, added {1} suggested values, pick list size = {2}", this.debuggingIdentifier, this.suggested.size(), pickList.size()));
                    }
                    if (this.allowed != null) {
                        pickList.retainAll(this.allowed);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)MessageFormat.format("{0}: computing picklist, retained {1} allowed values, pick list size = {2}", this.debuggingIdentifier, this.allowed.size(), pickList.size()));
                        }
                    }
                } else {
                    pickList.addAll(this.allowed);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)MessageFormat.format("{0}: computing picklist, added {1} allowed values, pick list size = {2}", this.debuggingIdentifier, this.allowed.size(), pickList.size()));
                    }
                }
                if (this.prohibited != null) {
                    pickList.removeAll(this.prohibited);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)MessageFormat.format("{0}: computing picklist, removed {1} prohibited values, pick list size = {2}", this.debuggingIdentifier, this.prohibited.size(), pickList.size()));
                    }
                }
                pickList.remove(null);
            }
            String[] values = pickList.toArray(new String[pickList.size()]);
            this.allowedValues = new AllowedValuesCollectionImpl(values, this.psType);
        }
        return this.allowedValues;
    }
}

