/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.type;

import com.microsoft.tfs.core.clients.workitem.fields.FieldStatus;
import com.microsoft.tfs.core.clients.workitem.internal.InternalWorkItemUtils;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterException;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIValueSource;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DateTime;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class WIDateTypeConverter
implements WITypeConverter {
    @Override
    public Object translate(Object input, WIValueSource valueSource) throws WITypeConverterException {
        if (input == null) {
            return null;
        }
        if (input instanceof Date) {
            return input;
        }
        if (input instanceof String) {
            String valueToParse = ((String)input).trim();
            if (valueSource == WIValueSource.SERVER) {
                if ("9999-01-01T00:00:00.000".equals(valueToParse)) {
                    return null;
                }
                try {
                    SimpleDateFormat format = InternalWorkItemUtils.newMetadataDateFormat();
                    return format.parse(valueToParse);
                }
                catch (ParseException ex) {
                    throw new WITypeConverterException(MessageFormat.format("unable to convert value [{0}] to a Date (SERVER value)", valueToParse), ex);
                }
            }
            if (valueToParse.length() == 0) {
                return null;
            }
            try {
                Date date = DateTime.parse(valueToParse, Locale.getDefault(), TimeZone.getDefault());
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                int year = cal.get(1);
                if (year < 1753 || year > 9999) {
                    throw new WITypeConverterException(MessageFormat.format("The date is out of range (year={0})", year), FieldStatus.INVALID_DATE, date);
                }
                return date;
            }
            catch (DateTime.UncheckedParseException ex) {
                throw new WITypeConverterException(MessageFormat.format("unable to convert value [{0}] to a Date (LOCAL value)", valueToParse), ex);
            }
        }
        throw new WITypeConverterException(MessageFormat.format("unable to convert [{0}] to a Date", input.getClass().getName()));
    }

    @Override
    public String toString(Object data) {
        if (data == null) {
            return null;
        }
        SimpleDateFormat format = InternalWorkItemUtils.newMetadataDateFormat();
        return format.format((Date)data);
    }
}

