/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query.qe;

import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinitionCollection;
import com.microsoft.tfs.util.Check;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class DisplayField {
    private String fieldName;
    private int width;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static String getInvariantFieldName(String fieldName, FieldDefinitionCollection fieldDefinitions) {
        if (fieldDefinitions != null) {
            return fieldDefinitions.get(fieldName).getReferenceName();
        }
        return fieldName;
    }

    public static String getLocalizedFieldName(String fieldName, FieldDefinitionCollection fieldDefinitions) {
        if (fieldDefinitions != null) {
            return fieldDefinitions.get(fieldName).getName();
        }
        return fieldName;
    }

    public DisplayField(String fieldName, int width) {
        this.fieldName = fieldName;
        this.width = width;
    }

    public String toString() {
        return this.fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        Check.notNull(fieldName, "fieldName");
        String old = this.fieldName;
        this.fieldName = fieldName;
        this.propertyChangeSupport.firePropertyChange("fieldName", old, fieldName);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        Check.isTrue(width >= 0, "width out of range");
        int old = this.width;
        this.width = width;
        this.propertyChangeSupport.firePropertyChange("width", old, width);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

