/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.httpclient.internal;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfSignedX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log log = LogFactory.getLog(SelfSignedX509TrustManager.class);

    public SelfSignedX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers.length == 0) {
            throw new NoSuchAlgorithmException("No trust manager found");
        }
        if (!(trustManagers[0] instanceof X509TrustManager)) {
            throw new NoSuchAlgorithmException("No X509 trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustManagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && certificates.length >= 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Accepting self-signed certificate with certificate chain:");
                for (int i = 0; i < certificates.length; ++i) {
                    log.debug((Object)MessageFormat.format("X509Certificate[{0}] = {1}", Integer.toString(i), certificates[i]));
                }
            }
            certificates[0].checkValidity();
        } else {
            this.standardTrustManager.checkServerTrusted(certificates, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

