/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.externaltools;

import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.core.externaltools.ExternalToolAssociation;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class ExternalToolset {
    public static final String DIRECTORY_EXTENSION = "/";
    public static final String WILDCARD_EXTENSION = "*";
    private static final String ASSOCIATION_MEMENTO_NAME = "association";
    private final List<ExternalToolAssociation> associations = new ArrayList<ExternalToolAssociation>();

    public synchronized ExternalTool findTool(File file) {
        Check.notNull(file, "file");
        if (file.isDirectory()) {
            return this.findToolForDirectory();
        }
        return this.findToolForExtension(LocalPath.getFileExtension(file.getName()));
    }

    public synchronized ExternalTool findTool(String path) {
        Check.notNull(path, "path");
        return this.findTool(new File(path));
    }

    public synchronized ExternalTool findToolForDirectory() {
        for (ExternalToolAssociation association : this.associations) {
            if (!association.containsExtension(DIRECTORY_EXTENSION)) continue;
            return association.getTool();
        }
        return null;
    }

    public synchronized ExternalTool findToolForExtension(String extension) {
        Check.notNull(extension, "extension");
        Check.isTrue(!extension.equals(DIRECTORY_EXTENSION), "the extension must not be the special directory extension /");
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        for (ExternalToolAssociation association : this.associations) {
            if (!association.containsExtension(extension)) continue;
            return association.getTool();
        }
        for (ExternalToolAssociation association : this.associations) {
            if (!association.containsExtension(WILDCARD_EXTENSION)) continue;
            return association.getTool();
        }
        return null;
    }

    public synchronized void addAssociation(ExternalToolAssociation association) {
        Check.notNull(association, ASSOCIATION_MEMENTO_NAME);
        this.associations.add(association);
    }

    public final synchronized void clear() {
        this.associations.clear();
    }

    public synchronized ExternalToolAssociation get(int index) {
        return this.associations.get(index);
    }

    public final synchronized boolean isEmpty() {
        return this.associations.isEmpty();
    }

    public synchronized ExternalToolAssociation remove(int index) {
        return this.associations.remove(index);
    }

    public synchronized boolean remove(ExternalToolAssociation association) {
        Check.notNull(association, ASSOCIATION_MEMENTO_NAME);
        return this.associations.remove(association);
    }

    public final synchronized int size() {
        return this.associations.size();
    }

    public synchronized ExternalToolAssociation[] getFileAssociations() {
        ArrayList<ExternalToolAssociation> ret = new ArrayList<ExternalToolAssociation>();
        for (ExternalToolAssociation association : this.associations) {
            if (association.containsExtension(DIRECTORY_EXTENSION)) continue;
            ret.add(association);
        }
        return ret.toArray(new ExternalToolAssociation[ret.size()]);
    }

    public synchronized ExternalToolAssociation getDirectoryAssociation() {
        for (ExternalToolAssociation association : this.associations) {
            if (!association.containsExtension(DIRECTORY_EXTENSION)) continue;
            return association;
        }
        return null;
    }

    public synchronized void saveToMemento(Memento memento) {
        Check.notNull(memento, "memento");
        for (ExternalToolAssociation association : this.associations) {
            Memento associationMemento = memento.createChild(ASSOCIATION_MEMENTO_NAME);
            association.saveToMemento(associationMemento);
        }
    }

    public static ExternalToolset loadFromMemento(Memento memento) {
        if (memento == null) {
            return new ExternalToolset();
        }
        Memento[] associationsChildren = memento.getChildren(ASSOCIATION_MEMENTO_NAME);
        ExternalToolset ret = new ExternalToolset();
        for (int i = 0; i < associationsChildren.length; ++i) {
            ret.addAssociation(ExternalToolAssociation.loadFromMemento(associationsChildren[i]));
        }
        return ret;
    }
}

