/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.persistence;

import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.persistence.FilesystemPersistenceStore;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.core.util.SpecialFolders;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionedVendorFilesystemPersistenceStore
extends FilesystemPersistenceStore {
    private static final Log log = LogFactory.getLog(VersionedVendorFilesystemPersistenceStore.class);

    public VersionedVendorFilesystemPersistenceStore(String vendorName, String applicationName, String version) {
        this(VersionedVendorFilesystemPersistenceStore.makeDirectoryForVendorApplicationVersion(vendorName, applicationName, version));
    }

    protected VersionedVendorFilesystemPersistenceStore(File directory) {
        super(directory);
    }

    private static File makeDirectoryForVendorApplicationVersion(String vendorName, String applicationName, String version) {
        Check.notNullOrEmpty(vendorName, "vendorName");
        Check.notNullOrEmpty(applicationName, "applicationName");
        Check.notNullOrEmpty(version, "version");
        String path = PlatformMiscUtils.getInstance().getEnvironmentVariable("TEE_PROFILE_DIRECTORY");
        if (path != null) {
            path = path.trim();
            try {
                if (StringUtil.isNullOrEmpty(path)) {
                    log.warn((Object)"User specified profile location path is empty, TEE will use default profile location.");
                } else if (!LocalPath.isPathRooted(path)) {
                    log.warn((Object)("User specified location " + path + "is not an absolute path. TEE will use default profile location."));
                } else {
                    File file = new File(path).getCanonicalFile();
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (file.exists() && file.isDirectory() && file.canRead() && file.canWrite()) {
                        return file;
                    }
                    log.warn((Object)("User specified location " + path + "can not be accessed. TEE will use default profile location."));
                }
            }
            catch (IOException e) {
                log.error((Object)("Exception testing profile location specified by the user: " + path + ".\n" + "TEE will use the default profile location."), (Throwable)e);
            }
        }
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            path = SpecialFolders.getLocalApplicationDataPath();
            if (!(path != null && path.length() != 0 || (path = SpecialFolders.getApplicationDataPath()) != null && path.length() != 0)) {
                path = SpecialFolders.getCommonApplicationDataPath();
            }
            path = path + File.separator + vendorName;
        } else {
            path = Platform.isCurrentPlatform(Platform.MAC_OS_X) ? System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support" + File.separator + vendorName : System.getProperty("user.home") + File.separator + "." + vendorName.toLowerCase();
        }
        path = path + File.separator + applicationName + File.separator + version;
        log.debug((Object)MessageFormat.format("Using path {0} for vendorName {1}, application {2}, and version {3}", path, vendorName, applicationName, version));
        return new File(path);
    }

    @Override
    public PersistenceStore getChildStore(String childName) {
        return new VersionedVendorFilesystemPersistenceStore(new File(this.getStoreFile(), childName));
    }
}

