/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.diffmerge;

import com.microsoft.tfs.core.clients.versioncontrol.MergeSummary;
import com.microsoft.tfs.core.clients.versioncontrol.ResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.core.externaltools.validators.ExternalToolException;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.diffmerge.ExternalRunner;
import com.microsoft.tfs.core.util.diffmerge.internal.libsgdcore_lite;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.process.ProcessFinishedHandler;
import com.microsoft.tfs.util.process.ProcessRunner;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public final class ThreeWayMerge {
    private String mergedFileLabel = null;
    private String mergedFileName = null;
    private FileEncoding mergedEncoding = null;
    private String baseFileLabel = null;
    private String baseFileName = null;
    private FileEncoding baseEncoding = null;
    private String yourFileLabel = null;
    private String yourFileName = null;
    private FileEncoding yourEncoding = null;
    private String theirFileLabel = null;
    private String theirFileName = null;
    private FileEncoding theirEncoding = null;
    private FileEncoding intermediateEncoding = null;
    private String overrideMergedFileEndOfLine = null;

    public ThreeWayMerge() {
    }

    public ThreeWayMerge(String overrideMergedFileEndOfLine) {
        this.overrideMergedFileEndOfLine = overrideMergedFileEndOfLine;
    }

    public void setBaseFileName(String file) {
        this.baseFileName = file;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public void setTheirFileName(String file) {
        this.theirFileName = file;
    }

    public String getTheirFileName() {
        return this.theirFileName;
    }

    public void setYourFileName(String file) {
        this.yourFileName = file;
    }

    public String getYourFileName() {
        return this.yourFileName;
    }

    public void setMergedFileName(String file) {
        this.mergedFileName = file;
    }

    public String getMergedFileName() {
        return this.mergedFileName;
    }

    public String getBaseFileLabel() {
        return this.baseFileLabel;
    }

    public String getMergedFileLabel() {
        return this.mergedFileLabel;
    }

    public String getTheirFileLabel() {
        return this.theirFileLabel;
    }

    public String getYourFileLabel() {
        return this.yourFileLabel;
    }

    public void setBaseFileLabel(String baseFileLabel) {
        this.baseFileLabel = baseFileLabel;
    }

    public void setMergedFileLabel(String mergedFileLabel) {
        this.mergedFileLabel = mergedFileLabel;
    }

    public void setTheirFileLabel(String theirFileLabel) {
        this.theirFileLabel = theirFileLabel;
    }

    public void setYourFileLabel(String yourFileLabel) {
        this.yourFileLabel = yourFileLabel;
    }

    public void setBaseFileEncoding(FileEncoding encoding) {
        this.baseEncoding = encoding;
    }

    public FileEncoding getBaseFileEncoding() {
        return this.baseEncoding;
    }

    public void setOriginalFileEncoding(FileEncoding encoding) {
        this.theirEncoding = encoding;
    }

    public FileEncoding getOriginalFileEncoding() {
        return this.theirEncoding;
    }

    public void setModifiedFileEncoding(FileEncoding encoding) {
        this.yourEncoding = encoding;
    }

    public FileEncoding getModifiedFileEncoding() {
        return this.yourEncoding;
    }

    public void setMergedFileEncoding(FileEncoding encoding) {
        this.mergedEncoding = encoding;
    }

    public FileEncoding getMergedFileEncoding() {
        return this.mergedEncoding;
    }

    public void setIntermediateMergeEncoding(FileEncoding encoding) {
        this.intermediateEncoding = encoding;
    }

    public FileEncoding getIntermediateMergeEncoding() {
        return this.intermediateEncoding;
    }

    public ProcessRunner beginExternalMerge(Conflict conflict, ExternalTool tool, ProcessFinishedHandler finishedHandler, OutputStream capturedStandardOutput, OutputStream capturedStandardError) throws IOException, ExternalToolException {
        Check.notNull(conflict, "conflict");
        Check.notNull(tool, "tool");
        if (this.getMergedFileName() == null) {
            File tempMergedFile = this.createMergeOutputFile();
            this.setMergedFileName(tempMergedFile.getAbsolutePath());
        }
        File mergedFile = new File(this.getMergedFileName());
        mergedFile.delete();
        return ExternalRunner.beginMerge(this, tool, finishedHandler, capturedStandardOutput, capturedStandardError);
    }

    public boolean endExternalMerge(ProcessRunner mergeProcess) {
        if (mergeProcess == null) {
            return false;
        }
        return ExternalRunner.endMerge(mergeProcess, this.getMergedFileName());
    }

    public boolean doInternalMerge(Conflict conflict, boolean onlyCountConflicts) {
        Charset[] detectedCharset = new Charset[1];
        String[] detectedEol = new String[1];
        boolean[] detectedTrailingEol = new boolean[]{true};
        Charset yourCharset = CodePageMapping.getCharset(conflict.getYourEncoding().getCodePage());
        Charset theirCharset = CodePageMapping.getCharset(conflict.getTheirEncoding().getCodePage());
        int baseCodePage = conflict.getBaseEncoding().getCodePage();
        Charset baseCharset = baseCodePage > 0 ? CodePageMapping.getCharset(baseCodePage) : yourCharset;
        libsgdcore_lite.svn_diff_t diff = libsgdcore_lite.svn_diff3_file(this.getBaseFileName(), baseCharset, this.getYourFileName(), yourCharset, this.getTheirFileName(), theirCharset, detectedCharset, detectedEol, detectedTrailingEol);
        int common = 0;
        int diffModified = 0;
        int diffLatest = 0;
        int diffCommon = 0;
        int conflicts = 0;
        libsgdcore_lite.svn_diff_t iteratorDiff = diff;
        while (iteratorDiff != null) {
            if (iteratorDiff.type == libsgdcore_lite.type_e.type_common) {
                ++common;
            } else if (iteratorDiff.type == libsgdcore_lite.type_e.type_diff_modified) {
                ++diffModified;
            } else if (iteratorDiff.type == libsgdcore_lite.type_e.type_diff_latest) {
                ++diffLatest;
            } else if (iteratorDiff.type == libsgdcore_lite.type_e.type_diff_common) {
                ++diffCommon;
            } else if (iteratorDiff.type == libsgdcore_lite.type_e.type_conflict) {
                ++conflicts;
            }
            iteratorDiff = iteratorDiff.next;
        }
        conflict.setContentMergeSummary(new MergeSummary(common, diffModified, diffLatest, diffCommon, conflicts));
        if (conflicts > 0 || onlyCountConflicts) {
            return false;
        }
        try {
            File mergedFile = this.createMergeOutputFile();
            FileOutputStream fos = new FileOutputStream(mergedFile);
            Charset outputCharset = detectedCharset[0];
            if (conflict.getResolutionOptions().getEncodingStrategy() == ResolutionOptions.EncodingStrategy.CONVERT_EXPLICIT) {
                outputCharset = CodePageMapping.getCharset(conflict.getResolutionOptions().getExplicitEncoding().getCodePage());
            }
            OutputStreamWriter encWriter = outputCharset != null ? new OutputStreamWriter((OutputStream)fos, outputCharset) : new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(encWriter);
            libsgdcore_lite.svn_diff3_file_output(bw, diff, this.overrideMergedFileEndOfLine != null ? this.overrideMergedFileEndOfLine : detectedEol[0], detectedTrailingEol[0], this.getBaseFileName(), baseCharset, this.getYourFileName(), yourCharset, this.getTheirFileName(), theirCharset, null, null, null, null, true, false);
            bw.close();
            this.setMergedFileName(mergedFile.getAbsolutePath());
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    private File createMergeOutputFile() throws IOException {
        File modifiedFile = new File(this.getYourFileName());
        File mergedFile = TempStorageService.getInstance().createTempFile(modifiedFile.getParentFile(), LocalPath.getFileExtension(modifiedFile.getAbsolutePath()));
        return mergedFile;
    }
}

