/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.logging.config;

import com.microsoft.tfs.logging.config.DebugLogger;
import com.microsoft.tfs.logging.config.LoggingConfigurationProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class FromFileConfigurationProvider
implements LoggingConfigurationProvider {
    private final File[] locations;

    public FromFileConfigurationProvider(File[] locations) {
        if (locations == null) {
            throw new IllegalArgumentException("locations must not be null");
        }
        this.locations = locations;
    }

    @Override
    public URL getConfigurationURL() {
        for (int i = 0; i < this.locations.length; ++i) {
            if (this.locations[i].exists()) {
                try {
                    return this.locations[i].toURL();
                }
                catch (MalformedURLException e) {
                    System.err.println("ERROR: " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
            }
            DebugLogger.verbose("configuration file not found at [" + this.locations[i].getAbsolutePath() + "]");
        }
        return null;
    }
}

