/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.TypesafeEnum;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class GUID
implements Serializable,
Comparable<GUID> {
    public static final GUID EMPTY = new GUID("00000000-0000-0000-0000-000000000000");
    static final long serialVersionUID = -108693329452431991L;
    private final byte[] guidBytes;
    private final Map<GUIDStringFormat, String> guidStrings = new HashMap<GUIDStringFormat, String>();

    public GUID(GUID guid) {
        Check.notNull(guid, "guid");
        this.guidBytes = guid.getGUIDBytes();
    }

    public GUID(String guidString) {
        Check.notNull(guidString, "guidString");
        if (guidString.indexOf(45) != -1) {
            if (guidString.startsWith("{") && guidString.endsWith("}")) {
                guidString = guidString.substring(1, guidString.length() - 1);
            } else if (guidString.startsWith("(") && guidString.endsWith(")")) {
                guidString = guidString.substring(1, guidString.length() - 1);
            }
            String[] parts = guidString.split("-");
            if (parts.length != 5 || parts[0].length() != 8 || parts[1].length() != 4 || parts[2].length() != 4 || parts[3].length() != 4 || parts[4].length() != 12) {
                throw new IllegalArgumentException(Messages.getString("GUID.SpecifiedStringIsNotValidGUID"));
            }
        } else if (guidString.length() != 32) {
            throw new IllegalArgumentException(Messages.getString("GUID.SpecifiedStringIsNotValidGUID"));
        }
        this.guidBytes = GUID.getGUIDBytes(guidString);
    }

    public GUID(byte[] guidBytes) {
        Check.notNull(guidBytes, "guidBytes");
        Check.isTrue(guidBytes.length == 16, "guidBytes.length == 16");
        this.guidBytes = (byte[])guidBytes.clone();
    }

    public static GUID newGUID() {
        return new GUID(GUID.newGUIDString());
    }

    public static String newGUIDString() {
        return UUID.randomUUID().toString();
    }

    public byte[] getGUIDBytes() {
        return (byte[])this.guidBytes.clone();
    }

    public final String getGUIDString() {
        return this.getGUIDString(GUIDStringFormat.DASHED);
    }

    public final String getGUIDString(GUIDStringFormat format) {
        if (format == null) {
            format = GUIDStringFormat.DASHED;
        }
        if (this.guidStrings.containsKey(format)) {
            return this.guidStrings.get(format);
        }
        String guidString = this.createGUIDString(format);
        this.guidStrings.put(format, guidString);
        return guidString;
    }

    private String createGUIDString(GUIDStringFormat format) {
        StringBuffer sb = new StringBuffer();
        if (format.equals(GUIDStringFormat.BRACES)) {
            sb.append('{');
        } else if (format.equals(GUIDStringFormat.PARENTHESES)) {
            sb.append('(');
        }
        byte[] bytes = (byte[])this.guidBytes.clone();
        GUID.swapBytes(bytes, 0, 3);
        GUID.swapBytes(bytes, 1, 2);
        GUID.swapBytes(bytes, 4, 5);
        GUID.swapBytes(bytes, 6, 7);
        for (int i = 0; i < bytes.length; ++i) {
            short unsignedByte;
            String hex;
            if (!(format.equals(GUIDStringFormat.NONE) || i != 4 && i != 6 && i != 8 && i != 10)) {
                sb.append('-');
            }
            if ((hex = Integer.toHexString(unsignedByte = (short)(0xFF & bytes[i]))).length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        if (format.equals(GUIDStringFormat.BRACES)) {
            sb.append('}');
        } else if (format.equals(GUIDStringFormat.PARENTHESES)) {
            sb.append(')');
        }
        return sb.toString().toLowerCase(Locale.US);
    }

    private static byte[] getGUIDBytes(String guidString) {
        if ((guidString = guidString.replaceAll("-", "")).length() != 32) {
            throw new IllegalArgumentException(Messages.getString("GUID.SpecifiedStringIsNotValidGUID"));
        }
        byte[] bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            int offset = i * 2;
            bytes[i] = (byte)Integer.parseInt(guidString.substring(offset, offset + 2), 16);
        }
        GUID.swapBytes(bytes, 0, 3);
        GUID.swapBytes(bytes, 1, 2);
        GUID.swapBytes(bytes, 4, 5);
        GUID.swapBytes(bytes, 6, 7);
        return bytes;
    }

    private static void swapBytes(byte[] bytes, int offset1, int offset2) {
        byte temp = bytes[offset1];
        bytes[offset1] = bytes[offset2];
        bytes[offset2] = temp;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GUID)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        GUID other = (GUID)object;
        return Arrays.equals(other.guidBytes, this.guidBytes);
    }

    public int hashCode() {
        int hashCode = 17;
        for (int i = 0; i < this.guidBytes.length; ++i) {
            hashCode = 31 * hashCode + this.guidBytes[i];
        }
        return hashCode;
    }

    public String toString() {
        return this.getGUIDString();
    }

    public static String[] toStringArray(GUID[] guids) {
        if (guids == null) {
            return null;
        }
        String[] strings = new String[guids.length];
        for (int i = 0; i < guids.length; ++i) {
            strings[i] = guids[i].getGUIDString();
        }
        return strings;
    }

    @Override
    public int compareTo(GUID other) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.getGUIDString(GUIDStringFormat.NONE), other.getGUIDString(GUIDStringFormat.NONE));
    }

    public static final class GUIDStringFormat
    extends TypesafeEnum {
        public static final GUIDStringFormat NONE = new GUIDStringFormat(0);
        public static final GUIDStringFormat DASHED = new GUIDStringFormat(1);
        public static final GUIDStringFormat BRACES = new GUIDStringFormat(2);
        public static final GUIDStringFormat PARENTHESES = new GUIDStringFormat(3);

        private GUIDStringFormat(int value) {
            super(value);
        }
    }
}

